<?php
	global $otw_pctp_validate_messages;
	
	$message = '';
	$massages = array();
	$messages[1] = esc_html__( 'Single Posts Template saved.', 'otw_pctp' );
	$messages[2] = esc_html__( 'Single Posts Template deleted.', 'otw_pctp' );
	$messages[5] = esc_html__( 'Single Posts Template copied.', 'otw_pctp' );
	
	if( otw_get('message',false) && isset( $messages[ otw_get('message','') ] ) ){
		$message .= $messages[ otw_get('message','') ];
	}
	
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo otw_esc_text( $message ); ?></p></div>
<?php
 endif; ?>
<div class="wrap">
	<div id="icon-options-general" class="icon32"></div>
	<h2><?php echo otw_esc_text( $page_title ); ?>
		<a class="button add-new-h2" href="admin.php?page=otw-pctp"><?php esc_html_e('Back to custom templates list', 'otw_pctp') ?></a>
	</h2>
	<?php if( isset( $otw_pctp_validate_messages ) && count( $otw_pctp_validate_messages ) ){?>
		<div id="message" class="error">
			<?php foreach( $otw_pctp_validate_messages as $v_message ){
				echo '<p>'.$v_message.'</p>';
			}?>
		</div>
	<?php }?>
	<div id="poststuff">
		<form method="post" action="" class="validate">
			<input type="hidden" name="otw_pctp_action" value="manage_otw_pctp_custom_templates" />
			<?php wp_original_referer_field(true, 'previous'); wp_nonce_field('otw-pctp-manage'); ?>
			<div id="post-body">
				<div  class="form-wrap">
					<div class="form-field form-required">
						<label for="pctp_custom_template_title"><?php esc_html_e( 'Single Posts Template title', 'otw_pctp' );?></label>
						<input type="text" id="pctp_custom_template_title" value="<?php echo esc_attr( $otw_pctp_custom_template_values['title'] )?>" tabindex="1" size="30" name="pctp_custom_template_title"/>
						<p><?php esc_html_e( 'The name is how it appears on your site.', 'otw_pctp' );?></p>
					</div>
					<div id="<?php echo esc_attr( $otw_pctp_grid_manager_object->meta_name );?>">
						<div class="meta-box-sortables">
							<div class="postbox">
								<h3 class="hndle sitem_header"><span><?php esc_html_e( 'OTW Grid Manager', 'otw_pctp' )?></span></h3>
								<div class="inside">
									<?php echo $otw_pctp_grid_manager_object->build_custom_box( $otw_pctp_custom_template_values['grid_content'] );?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<p class="submit">
					<input type="submit" value="<?php esc_html_e( 'Save Single Posts Template', 'otw_pctp') ?>" name="submit" class="button button-primary button-hero"/>
				</p>
				<?php include_once( 'otw_pctp_custom_template_settings.php' )?>
				<p class="submit">
					<input type="submit" value="<?php esc_html_e( 'Save Single Posts Template', 'otw_pctp') ?>" name="submit" class="button button-primary button-hero"/>
				</p>
			</div>
		</form>
	</div>
</div>