<?php
/**
 * Init function
 */
 
if( !function_exists( 'otw_pctp_init' ) ){
	
	function otw_pctp_init(){
		
		global $otw_pctp_grid_manager_component, $otw_pctp_grid_manager_object, $otw_pctp_shortcode_component, $otw_pctp_shortcode_object, $otw_pctp_js_version, $otw_pctp_css_version, $otw_pctp_plugin_url, $otw_pctp_form_component, $otw_pctp_form_object, $otw_pctp_image_component, $otw_pctp_image_profile, $otw_pctp_image_object, $otw_pctp_content_sidebars_component, $otw_pctp_content_sidebars_object, $otw_pctp_factory_component, $otw_pctp_factory_object, $otw_pctp_plugin_id;
		
		if( is_admin() ){
		
			add_action( 'add_meta_boxes', 'otw_pctp_meta_boxes', 10, 2 );
			
			add_action( 'save_post', 'otw_pctp_save_meta_box' );
			
			add_action('admin_menu', 'otw_pctp_init_admin_menu' );
			
			add_action('admin_print_styles', 'otw_pctp_enqueue_admin_styles' );
			
			add_action('admin_enqueue_scripts', 'otw_pctp_enqueue_admin_scripts');
			
			add_filter( 'otwfcr_notice', 'otw_pctp_factory_message' );
			
			otw_pctp_register_predefined_templates();
		}else{
			add_action('wp_enqueue_scripts', 'otw_pctp_enqueue_styles');
		}
		
		otw_pctp_register_custom_sidebars();
		
		$otw_pctp_grid_manager_component = otw_load_component( 'otw_post_template_grid_manager' );
		$otw_pctp_grid_manager_object = otw_get_component( $otw_pctp_grid_manager_component );
		$otw_pctp_grid_manager_object->js_version = $otw_pctp_js_version;
		$otw_pctp_grid_manager_object->css_version = $otw_pctp_css_version;
		$otw_pctp_grid_manager_object->text_info = esc_html__( 'Add some rows and columns in the rows. Then you will be able to add your post elements and sidebars in the columns. Once you build your layout you can save it so you can use it for another page.', 'otw_pctp' );
		
		include_once( plugin_dir_path( __FILE__ ).'otw_labels/otw_pctp_grid_manager_object.labels.php' );
		$otw_pctp_grid_manager_object->init();
		
		$otw_pctp_factory_component = otw_load_component( 'otw_factory' );
		$otw_pctp_factory_object = otw_get_component( $otw_pctp_factory_component );
		$otw_pctp_factory_object->add_plugin( $otw_pctp_plugin_id, dirname( dirname( __FILE__ ) ).'/otw_post_custom_templates_pro.php', array( 'menu_parent' => 'otw-pctp', 'lc_name' => esc_html__( 'License Manager', 'otw_pctp' ), 'menu_key' => 'otw-pctp' ) );
		
		include_once( plugin_dir_path( __FILE__ ).'otw_labels/otw_pctp_factory_object.labels.php' );
		$otw_pctp_factory_object->init();
		
		if( $otw_pctp_factory_object->is_plugin_active( $otw_pctp_plugin_id ) ){
			
			$otw_pctp_shortcode_component = otw_load_component( 'otw_post_template_shortcode' );
			$otw_pctp_shortcode_object = otw_get_component( $otw_pctp_shortcode_component );
			$otw_pctp_shortcode_object->js_version = $otw_pctp_js_version;
			$otw_pctp_shortcode_object->css_version = $otw_pctp_css_version;
			
			$otw_pctp_shortcode_object->add_default_external_lib( 'css', 'style', get_stylesheet_directory_uri().'/style.css', 'live_preview', 10 );
			
			$otw_pctp_shortcode_object->shortcodes['post_item_title'] = array( 'title' => esc_html__('Post Title', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 100,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_meta'] = array( 'title' => esc_html__('Meta Items', 'otw_pctp' ), 'options' => true, 'enabled' => true,'children' => false,'order' => 101,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_media'] = array( 'title' => esc_html__('Post Media', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 102,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_description'] = array( 'title' => esc_html__('Post Description', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 103,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_tabs'] = array( 'title' => esc_html__('Post Tabs', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 104,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_social_icons'] = array( 'title' => esc_html__('Post Social Icons', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 105,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_prev_next_navigation'] = array( 'title' => esc_html__('Post Prev/Next Nav', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 106,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_related_posts'] = array( 'title' => esc_html__('Related Posts', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 107,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_comments'] = array( 'title' => esc_html__('Post Comments', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 108,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_reviews'] = array( 'title' => esc_html__('Post Reviews', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 110,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_author'] = array( 'title' => esc_html__('Post Author Info', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 111,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_facebook_comments'] = array( 'title' => esc_html__('Post Facebook Comments', 'otw_pctp'), 'options' => true, 'enabled' => true, 'children' =>false, 'order' => 112,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['post_item_custom_fields'] = array( 'title' => esc_html__('OTW Post Fields', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 113,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['divider'] = array('title' => esc_html__('Divider', 'otw_pctp' ), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 130, 'path' => dirname(__FILE__) . '/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url . 'include/otw_components/otw_post_template_shortcode/');
			$otw_pctp_shortcode_object->shortcodes['sidebars'] = array( 'title' => esc_html__('Sidebars', 'otw_pctp' ),'enabled' => true,'children' => false,'order' => 132,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['ads'] = array( 'title' => esc_html__('Ads Shortcode', 'otw_pctp' ),'enabled' => true,'children' => false,'order' => 137,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			$otw_pctp_shortcode_object->shortcodes['breadcrumbs'] = array( 'title' => esc_html__('Breadcrumbs', 'otw_pctp'), 'options' => false, 'enabled' => true,'children' => false,'order' => 138,'parent' => false, 'path' => dirname( __FILE__ ).'/otw_components/otw_post_template_shortcode/', 'url' => $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );
			
			
			include_once( plugin_dir_path( __FILE__ ).'otw_labels/otw_pctp_shortcode_object.labels.php' );
			$otw_pctp_shortcode_object->init();
		}
		
		//form component
		$otw_pctp_form_component = otw_load_component( 'otw_form' );
		$otw_pctp_form_object = otw_get_component( $otw_pctp_form_component );
		$otw_pctp_form_object->js_version = $otw_pctp_js_version;
		$otw_pctp_form_object->css_version = $otw_pctp_css_version;
		
		global $wp_filesystem;
		
		if( otw_init_filesystem() ){
			
			if( $wp_filesystem->is_file( plugin_dir_path( __FILE__ ).'otw_labels/otw_pctp_form_object.labels.php' ) ){
				include_once( plugin_dir_path( __FILE__ ).'otw_labels/otw_pctp_form_object.labels.php' );
			}
		}
		$otw_pctp_form_object->init();
		
		//content sidebars component
		if( $otw_pctp_factory_object->is_plugin_active( $otw_pctp_plugin_id ) ){
			
			$otw_pctp_content_sidebars_component = otw_load_component('otw_content_sidebars');
			$otw_pctp_content_sidebars_object = otw_get_component($otw_pctp_content_sidebars_component);
			$otw_pctp_content_sidebars_object->admin_menu = false;
			$otw_pctp_content_sidebars_object->meta_name = 'otw_content_sidebars_settings';
			$otw_pctp_content_sidebars_object->js_version = $otw_pctp_js_version;
			$otw_pctp_content_sidebars_object->css_version = $otw_pctp_css_version;
			
			include_once( plugin_dir_path(__FILE__) . 'otw_labels/otw_pctp_content_sidebars_object.labels.php' );
			$otw_pctp_content_sidebars_object->init();
		}
		
		$otw_pctp_image_component = otw_load_component( 'otw_image' );
		
		$otw_pctp_image_object = otw_get_component( $otw_pctp_image_component );
		
		$otw_pctp_image_object->init();
		
		$img_location = wp_upload_dir();
		
		$otw_pctp_image_profile = $otw_pctp_image_object->add_profile( $img_location['basedir'].'/', $img_location['baseurl'].'/', 'otwpct' );
		
		if( $otw_pctp_factory_object->is_plugin_active( $otw_pctp_plugin_id ) ){
			include_once( 'otw_pctp_process_actions.php' );
		}
	}
}

/**
 * Write template css to the disk
 */
if( !function_exists( 'otw_pctp_save_template_css' ) ){
	
	function otw_pctp_save_template_css( $template_id, $data ){
		
		global $otw_pctp_template_custom_css_path;
		
		$css_string = '';
		$open_rule = '';
		$fonts = otw_pctp_fonts_array();
		$google_fonts = array();
		
		//title style
		if( isset( $data['otw_pct_item_title_font_size'] ) && strlen( trim( $data['otw_pct_item_title_font_size'] ) ) ){
			$open_rule .= ' font-size: '.$data['otw_pct_item_title_font_size'].'px !important;';
		}
		
		if( isset( $data['otw_pct_item_title_font_name'] ) && strlen( trim( $data['otw_pct_item_title_font_name'] ) ) && array_key_exists( $data['otw_pct_item_title_font_name'], $fonts ) ){
			$open_rule .= ' font-family: '.$fonts[ $data['otw_pct_item_title_font_name'] ]->text.' !important;';
			if( $fonts[ $data['otw_pct_item_title_font_name'] ]->id > 9 ){
				$google_fonts[ $fonts[ $data['otw_pct_item_title_font_name'] ]->id ] = $fonts[ $data['otw_pct_item_title_font_name'] ]->text;
			}
		}
		
		if( isset( $data['otw_pct_item_title_font_style'] ) && strlen( trim( $data['otw_pct_item_title_font_style'] ) ) ){
			
			switch( $data['otw_pct_item_title_font_style'] ){
				
				case 'bold':
						$open_rule .= ' font-weight: '.$data['otw_pct_item_title_font_style'].' !important;';
					break;
				case 'italic':
						$open_rule .= ' font-style: '.$data['otw_pct_item_title_font_style'].' !important;';
					break;
				case 'bold_italic':
						$open_rule .= ' font-weight: bold !important;';
						$open_rule .= ' font-style: italic !important;';
					break;
			}
		}
		
		if( isset( $data['otw_pct_item_title_color'] ) && strlen( trim( $data['otw_pct_item_title_color'] ) ) ){
			$open_rule .= ' color: '.$data['otw_pct_item_title_color'].' !important;';
		}
		
		if( isset( $data['otw_pct_item_title_alignment'] ) && strlen( trim( $data['otw_pct_item_title_alignment'] ) ) ){
			$open_rule .= ' text-align: '.$data['otw_pct_item_title_alignment'].' !important;';
		}
		
		if( $open_rule ){
			
			$css_string .= '.otw_pct_ct_'.$template_id.' .otw_post_content-blog-title{'.$open_rule.'}';
			$open_rule = '';
		}
		
		global $wp_filesystem;
		
		if( otw_init_filesystem() ){
			
			//write the file to the disk
			if( $wp_filesystem->is_writable( $otw_pctp_template_custom_css_path ) ){
				
				$file_name = $otw_pctp_template_custom_css_path.'otw_pct_ct_'.$template_id.'.css';
				
				if( count( $google_fonts ) ){
					
					foreach( $google_fonts as $g_font ){
						
						$css_string = "@import url(//fonts.googleapis.com/css?family=". urlencode( $g_font ).");\n".$css_string;
					}
				}
				
				//save the file to the disk
				if( strlen( $css_string ) ){
					$wp_filesystem->put_contents( $file_name, $css_string );
				}
				elseif( $wp_filesystem->exists( $file_name ) ){
					$wp_filesystem->delete( $file_name );
				}
			}
		}
	}
}
/**
 * Init admin menu
 */
if( !function_exists( 'otw_pctp_init_admin_menu' ) ){
	
	function otw_pctp_init_admin_menu(){
		
		global $otw_pctp_plugin_url, $otw_pctp_plugin_id, $otw_pctp_factory_object;
		
		$menu_parent = 'otw-pctp';
		
		add_menu_page(__('Post Custom Templates', 'otw_pctp'), esc_html__('Post Custom Templates', 'otw_pctp'), 'manage_options', 'otw-pctp', 'otw_pctp_custom_templates', $otw_pctp_plugin_url.'/images/otw-menu-icon.png');
		
		if( $otw_pctp_factory_object->is_plugin_active( $otw_pctp_plugin_id ) ){
			add_submenu_page( $menu_parent, esc_html__('Post Custom Templates | Single Posts Templates', 'otw_pctp'), esc_html__('Single Posts Templates', 'otw_pctp'), 'manage_options', 'otw-pctp', 'otw_pctp_custom_templates' );
			add_submenu_page( $menu_parent, esc_html__('Post Custom Templates | Add Single Post Template', 'otw_pctp'), esc_html__('Add Template', 'otw_pctp'), 'manage_options', 'otw-pctp-custom-templates-add', 'otw_pctp_custom_templates_edit' );
			$hook_suffix_0 = add_submenu_page( __FILE__, esc_html__('Post Custom Templates | Single Posts Templates | Edit', 'otw_pctp'), esc_html__('Edit Single Posts Templates', 'otw_pctp'), 'manage_options', 'otw-pctp-custom-templates-edit', 'otw_pctp_custom_templates_edit' );
			$hook_suffix_1 = add_submenu_page( __FILE__, esc_html__('Post Custom Templates | Single Posts Templates | Confirmation', 'otw_pctp'), esc_html__('Action Single Posts Templates', 'otw_pctp'), 'manage_options', 'otw-pctp-custom-templates-action', 'otw_pctp_custom_templates_action' );
			
			add_submenu_page( $menu_parent, esc_html__('Post Custom Templates | Options', 'otw_pctp'), esc_html__('Options', 'otw_pctp'), 'manage_options', 'otw-pctp-settings', 'otw_pctp_settings' );
			
			add_action( 'load-' . $hook_suffix_0 , 'otw_pctp_open_admin_menu' );
			add_action( 'load-' . $hook_suffix_1 , 'otw_pctp_open_admin_menu' );
		}
	
	}
}

if( !function_exists( 'otw_pctp_open_admin_menu' ) ){
	
	function otw_pctp_open_admin_menu(){
		
		global $menu, $submenu;
		
		foreach( $menu as $key => $item ){
			
			if( $item[2] == 'otw-pctp' ){
				$menu[ $key ][4] = $menu[ $key ][4].' wp-has-submenu wp-has-current-submenu wp-menu-open menu-top otw-pctp-menu-open current';
				
				if( function_exists( 'get_current_screen' ) ){
				
					$screen = get_current_screen();
					
					if( preg_match( "/otw\-pctp\-add$/", $screen->base ) && isset( $submenu[ 'otw-pctp' ] ) && otw_get('action',false) && ( otw_get('action','') == 'edit' ) ){
						foreach( $submenu[ 'otw-pctp' ] as $s_key => $s_data ){
							
							if( $s_data[2] == 'otw-pctp' ){
								$submenu[ 'otw-pctp' ][ $s_key ][4] = 'current';
							}
						}
					}
				}
			}
		}
	}
}


/** get settings
  *
  */
if( !function_exists( 'otw_pctp_get_settings' ) ){
	
	function otw_pctp_get_settings( $otw_pct_plugin_options = array() ){
		
		if( !isset( $otw_pct_plugin_options['otw_pct_template'] ) ){
			
			$otw_pct_plugin_options['otw_pct_template'] = 'default';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_sidebar'] ) ){
			
			$otw_pct_plugin_options['otw_pct_sidebar'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_category_template'] ) ){
			$otw_pct_plugin_options['otw_pct_category_template'] = '';
		}
		
		return $otw_pct_plugin_options;
	}
}

/** get custom template settings
  *
  */
if( !function_exists( 'otw_pctp_get_content_sidebars_settings' ) ){
	
	function otw_pctp_get_content_sidebars_settings( $otw_pct_plugin_options = array() ){
		
		if( !isset( $otw_pct_plugin_options['cs'] ) || !isset( $otw_pct_plugin_options['cs']['layout'] ) ){
			
			$otw_pct_plugin_options['cs']['layout'] = '1c';
		}
		
		if( !isset( $otw_pct_plugin_options['cs'] ) || !isset( $otw_pct_plugin_options['cs']['sidebar1'] ) ){
			
			$otw_pct_plugin_options['cs']['sidebar1'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['cs'] ) || !isset( $otw_pct_plugin_options['cs']['sidebar2'] ) ){
			
			$otw_pct_plugin_options['cs']['sidebar2'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['cs'] ) || !isset( $otw_pct_plugin_options['cs']['sidebar1_size'] ) ){
			
			$otw_pct_plugin_options['cs']['sidebar1_size'] = '6';
		}
		
		if( !isset( $otw_pct_plugin_options['cs'] ) || !isset( $otw_pct_plugin_options['cs']['sidebar2_size'] ) ){
			
			$otw_pct_plugin_options['cs']['sidebar2_size'] = '6';
		}
		
		return $otw_pct_plugin_options;
	}
}
/** get custom template settings
  *
  */
if( !function_exists( 'otw_pctp_get_custom_template_settings' ) ){
	
	function otw_pctp_get_custom_template_settings( $otw_pct_plugin_options = array() ){
		
		if( !isset( $otw_pct_plugin_options['otw_pct_prev_next_nav'] ) ){
			
			$otw_pct_plugin_options['otw_pct_prev_next_nav'] = 'yes';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_related_posts'] ) ){
			$otw_pct_plugin_options['otw_pct_related_posts'] = 'yes';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_title_link'] ) ){
			$otw_pct_plugin_options['otw_pct_title_link'] = 'single';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_meta_items'] ) ){
			$otw_pct_plugin_options['otw_pct_meta_items'] = 'author,date,category,tags,comments';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_meta_icons'] ) ){
			$otw_pct_plugin_options['otw_pct_meta_icons'] = 'labels';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_meta_type_align'] ) ){
			$otw_pct_plugin_options['otw_pct_meta_type_align'] = 'horizontal';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_related_posts_criteria'] ) ){
			$otw_pct_plugin_options['otw_pct_related_posts_criteria'] = 'category';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_related_posts_number'] ) ){
			$otw_pct_plugin_options['otw_pct_related_posts_number'] = '4';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_social_title_text'] ) ){
			$otw_pct_plugin_options['otw_pct_social_title_text'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_post_fields_title_text'] ) ){
			$otw_pct_plugin_options['otw_pct_post_fields_title_text'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_post_fields_delimiters'] ) ){
			$otw_pct_plugin_options['otw_pct_post_fields_delimiters'] = 'yes';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_show_social_icons'] ) ){
			$otw_pct_plugin_options['otw_pct_show_social_icons'] = 'share_icons';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_social_icons_alignment'] ) ){
			$otw_pct_plugin_options['otw_pct_social_icons_alignment'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_show_social_icons_facebook'] ) ){
			$otw_pct_plugin_options['otw_pct_show_social_icons_facebook'] = '1';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_show_social_icons_twitter'] ) ){
			$otw_pct_plugin_options['otw_pct_show_social_icons_twitter'] = '1';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_show_social_icons_googleplus'] ) ){
			$otw_pct_plugin_options['otw_pct_show_social_icons_googleplus'] = '1';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_show_social_icons_linkedin'] ) ){
			$otw_pct_plugin_options['otw_pct_show_social_icons_linkedin'] = '1';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_show_social_icons_pinterest'] ) ){
			$otw_pct_plugin_options['otw_pct_show_social_icons_pinterest'] = '1';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_show_social_icons_custom'] ) ){
			$otw_pct_plugin_options['otw_pct_show_social_icons_custom'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_item_media_width'] ) ){
			$otw_pct_plugin_options['otw_pct_item_media_width'] = '';
		}
		if( !isset( $otw_pct_plugin_options['otw_pct_item_media_height'] ) ){
			$otw_pct_plugin_options['otw_pct_item_media_height'] = '';
		}
		if( !isset( $otw_pct_plugin_options['otw_pct_item_media_format'] ) ){
			$otw_pct_plugin_options['otw_pct_item_media_format'] = '';
		}
		if( !isset( $otw_pct_plugin_options['otw_pct_item_media_title_attr'] ) ){
			$otw_pct_plugin_options['otw_pct_item_media_title_attr'] = 'no';
		}
		if( !isset( $otw_pct_plugin_options['otw_pct_item_media_alt_attr'] ) ){
			$otw_pct_plugin_options['otw_pct_item_media_alt_attr'] = 'no';
		}
		if( !isset( $otw_pct_plugin_options['otw_pct_archive_media_ns_width'] ) ){
			$otw_pct_plugin_options['otw_pct_archive_media_ns_width'] = '';
		}
		if( !isset( $otw_pct_plugin_options['otw_pct_archive_media_ns_height'] ) ){
			$otw_pct_plugin_options['otw_pct_archive_media_ns_height'] = '';
		}
		if( !isset( $otw_pct_plugin_options['otw_pct_archive_media_ws_width'] ) ){
			$otw_pct_plugin_options['otw_pct_archive_media_ws_width'] = '';
		}
		if( !isset( $otw_pct_plugin_options['otw_pct_archive_media_ws_height'] ) ){
			$otw_pct_plugin_options['otw_pct_archive_media_ws_height'] = '';
		}
		if( !isset( $otw_pct_plugin_options['otw_pct_related_media_width'] ) ){
			$otw_pct_plugin_options['otw_pct_related_media_width'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_related_media_height'] ) ){
			$otw_pct_plugin_options['otw_pct_related_media_height'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_related_media_format'] ) ){
			$otw_pct_plugin_options['otw_pct_related_media_format'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_details_title_text'] ) ){
			$otw_pct_plugin_options['otw_pct_details_title_text'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_moreinfo_title_text'] ) ){
			$otw_pct_plugin_options['otw_pct_moreinfo_title_text'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_related_title_text'] ) ){
			$otw_pct_plugin_options['otw_pct_related_title_text'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_reviews_title_text'] ) ){
			$otw_pct_plugin_options['otw_pct_reviews_title_text'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_media_lightbox'] ) ){
			$otw_pct_plugin_options['otw_pct_media_lightbox'] = 'yes';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_item_media_lightbox_width'] ) ){
			$otw_pct_plugin_options['otw_pct_item_media_lightbox_width'] = '';
		}
		if( !isset( $otw_pct_plugin_options['otw_pct_item_media_lightbox_height'] ) ){
			$otw_pct_plugin_options['otw_pct_item_media_lightbox_height'] = '';
		}
		if( !isset( $otw_pct_plugin_options['otw_pct_item_media_lightbox_format'] ) ){
			$otw_pct_plugin_options['otw_pct_item_media_lightbox_format'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_item_theme_post_header'] ) ){
			$otw_pct_plugin_options['otw_pct_item_theme_post_header'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_item_theme_pre_footer'] ) ){
			$otw_pct_plugin_options['otw_pct_item_theme_pre_footer'] = '';
		}
		
		
		if( !isset( $otw_pct_plugin_options['otw_pct_item_title'] ) ){
			$otw_pct_plugin_options['otw_pct_item_title'] = 'yes';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_item_title_font_size'] ) ){
			$otw_pct_plugin_options['otw_pct_item_title_font_size'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_item_title_font_style'] ) ){
			$otw_pct_plugin_options['otw_pct_item_title_font_style'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_item_title_font_name'] ) ){
			$otw_pct_plugin_options['otw_pct_item_title_font_name'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_item_title_color'] ) ){
			$otw_pct_plugin_options['otw_pct_item_title_color'] = '';
		}
		
		if( !isset( $otw_pct_plugin_options['otw_pct_item_title_alignment'] ) ){
			$otw_pct_plugin_options['otw_pct_item_title_alignment'] = 'left';
		}
		
		return $otw_pct_plugin_options;
	}
}
/**
  * settings page
  */
 if( !function_exists( 'otw_pctp_settings' ) ){
	
	function otw_pctp_settings(){
		
		global $otw_pctp_custom_css_path, $wp_registered_sidebars;
		
		$otw_pct_plugin_options = otw_pctp_get_settings();
		
		$db_otw_pct_plugin_options = get_option( 'otw_mb_plugin_options' );
		
		foreach( $otw_pct_plugin_options as $setting_key => $value ){
		
			if( is_array( $db_otw_pct_plugin_options ) && isset( $db_otw_pct_plugin_options[ $setting_key ] ) ){
			
				$otw_pct_plugin_options[ $setting_key ] = $db_otw_pct_plugin_options[ $setting_key ];
			}
		}
		
		global $wp_filesystem;
		
		$customCss = '';
		
		if( otw_init_filesystem() ){
			
			if( $wp_filesystem->exists( $otw_pctp_custom_css_path ) ){
				$customCss = $wp_filesystem->get_contents( $otw_pctp_custom_css_path );
			}
		}
		
		$otw_pct_templates = array( 'default' => esc_html__( 'Theme\'s default template (default)', 'otw_pctp' ) ) + otw_get_post_templates();
		
		require_once( 'otw_pctp_settings.php' );
	}
}

/** custom templates
  *
  */
 if( !function_exists( 'otw_pctp_custom_templates' ) ){
	
	function otw_pctp_custom_templates(){
		
		$otw_custom_templates = otw_get_post_custom_templates();
		
		require_once('otw_pctp_custom_templates.php');
	}
}

/** edit custom templates
  *
  */
 if( !function_exists( 'otw_pctp_custom_templates_edit' ) ){
	
	function otw_pctp_custom_templates_edit(){
		
		global $otw_pctp_grid_manager_object, $otw_pctp_content_sidebars_object, $otw_pctp_plugin_id, $otw_pctp_factory_object;
		
		if( !$otw_pctp_factory_object->is_plugin_active( $otw_pctp_plugin_id ) ){
			return;
		}
		
		$page_title = 'Add Single Posts Template';
		
		$custom_templates = otw_get_post_custom_templates();
		
		$otw_pctp_custom_template_values = array();
		$otw_pctp_custom_template_values['title'] = '';
		$otw_pctp_custom_template_values['grid_content'] = '';
		$cs_settings = otw_pctp_get_content_sidebars_settings();
		$otw_pctp_custom_template_values['cs'] = $cs_settings['cs'];
		
		$default_options = otw_pctp_get_custom_template_settings();
		$otw_pctp_custom_template_values['options'] = $default_options;
		
		if( otw_get( 'custom_template', false ) && preg_match( "/^\d+$/", otw_get( 'custom_template', '' ) ) && intval( otw_get( 'custom_template', '' ) ) && array_key_exists( otw_get( 'custom_template', '' ), $custom_templates ) ){
			
			$page_title = 'Edit Single Posts Template';
			
			$otw_pctp_custom_template_values['title'] = $custom_templates[ otw_get( 'custom_template', '' ) ]['title'];
			$otw_pctp_custom_template_values['grid_content'] = otw_stripslashes( $custom_templates[ otw_get( 'custom_template', '' ) ]['grid_content'] );
			
			if( isset( $custom_templates[ otw_get( 'custom_template', '' ) ]['options'] ) && is_array( $custom_templates[ otw_get( 'custom_template', '' ) ]['options'] ) ){
				$otw_pctp_custom_template_values['options'] = $custom_templates[ otw_get( 'custom_template', '' ) ]['options'];
			}
			
			if( isset( $custom_templates[ otw_get( 'custom_template', '' ) ]['cs'] ) && is_array( $custom_templates[ otw_get( 'custom_template', '' ) ]['cs'] ) ){
				$otw_pctp_custom_template_values['cs'] = $custom_templates[ otw_get( 'custom_template', '' ) ]['cs'];
			}
			
			foreach( $default_options as $key => $value ){
				
				if( !isset( $otw_pctp_custom_template_values['options'][ $key ] ) ){
					$otw_pctp_custom_template_values['options'][ $key ] = $value;
				}
			}
		}
		
		if( otw_post( 'otw_pctp_action', false ) && ( otw_post( 'otw_pctp_action', '' ) == 'manage_otw_pctp_custom_templates' ) ){
		
			$otw_pctp_custom_template_values['title'] = otw_stripslashes( otw_post( 'pctp_custom_template_title', '' ) );
			$otw_pctp_custom_template_values['grid_content'] = otw_post( array( '_otw_post_template_grid_manager_content', 'code' ), '' );
			
			
			foreach( $otw_pctp_custom_template_values['options'] as $key => $value ){
			
				if( otw_post( $key, false ) ){
					$otw_pctp_custom_template_values['options'][ $key ] = otw_post( $key, '' );
				}
			}
		}
		
		$otw_pct_related_posts_criteria_options = array(
			'category' => esc_html__( 'Category (default)', 'otw_pctp' ),
			'post_tag' => esc_html__( 'Tag', 'otw_pctp' ),
			'handpicked' => esc_html__( 'Handpicked', 'otw_pctp' )
		);
		
		$otw_pct_related_posts_options = array(
			'' => esc_html__( 'No', 'otw_pctp' ),
			'yes' => esc_html__( 'Yes (default)', 'otw_pctp' )
		);
		
		$otw_pct_post_fields_delimiters_options = array(
			'' => esc_html__( 'No', 'otw_pctp' ),
			'yes' => esc_html__( 'Yes (default)', 'otw_pctp' )
		);
		
		$otw_pct_prev_next_nav_options = array(
			'' => esc_html__( 'No', 'otw_pctp' ),
			'yes' => esc_html__( 'Yes (default)', 'otw_pctp' )
		);
		
		$otw_pct_social_icons_options =array(
			array( 'value' => '0', 'text' => esc_html__('None', 'otw_pctp') ),
			array( 'value' => 'share_icons', 'text' => esc_html__('Share Icons (default)', 'otw_pctp') ),
			array( 'value' => 'share_btn_small', 'text' => esc_html__('Share Buttons Small', 'otw_pctp') ),
			array( 'value' => 'share_btn_large', 'text' => esc_html__('Share Buttons Large', 'otw_pctp') ),
			array( 'value' => 'like_buttons', 'text' => esc_html__('Like Buttons', 'otw_pctp') ),
			array( 'value' => 'custom_icons', 'text' => esc_html__('Custom Social Icons', 'otw_pctp') )
		);
		
		$otw_pct_item_media_format_options = array(
			'' => esc_html__('Keep original file format (default)', 'otw_pctp' ),
			'jpg' => 'jpg',
			'png' => 'png',
			'gif' => 'gif'
		);
		
		$otw_pct_media_lightbox_options = array(
			'yes' => esc_html__( 'Yes (default)', 'otw_pctp' ),
			'no' => esc_html__( 'No', 'otw_pctp' )
		);
		
		$total_meta_elements = 6;
		
		$meta_elements = array();
		
		$selectMetaData = array(
			array( 'value' => 'horizontal', 'text' => esc_html__('Horizontal (default)', 'otw_pctp') ),
			array( 'value' => 'vertical', 'text' => esc_html__('Vertical', 'otw_pctp') ),
		);
		
		$controls_options = otw_pctp_custom_templates_control_options();
		
		require_once('otw_pctp_custom_templates_manage.php');
	}
}

/** controls options
  *
  */
if( !function_exists( 'otw_pctp_custom_templates_control_options' ) ){
	
	function otw_pctp_custom_templates_control_options(){
	
		$options = array();
		
		$options['font_sizes'] = array(
			array( 'value' => '', 'text' => esc_html__('None (default)', 'otw_pctp' ) ),
			array( 'value' => '8', 'text' => '8px' ),
			array( 'value' => '10', 'text' => '10px' ),
			array( 'value' => '12', 'text' => '12px' ),
			array( 'value' => '14', 'text' => '14px' ),
			array( 'value' => '16', 'text' => '16px' ),
			array( 'value' => '18', 'text' => '18px' ),
			array( 'value' => '20', 'text' => '20px' ),
			array( 'value' => '22', 'text' => '22px' ),
			array( 'value' => '24', 'text' => '24px' ),
			array( 'value' => '26', 'text' => '26px' ),
			array( 'value' => '28', 'text' => '28px' ),
			array( 'value' => '30', 'text' => '30px' ),
			array( 'value' => '32', 'text' => '32px' ),
			array( 'value' => '34', 'text' => '34px' ),
			array( 'value' => '36', 'text' => '36px' ),
			array( 'value' => '38', 'text' => '38px' ),
			array( 'value' => '40', 'text' => '40px' ),
			array( 'value' => '42', 'text' => '42px' ),
			array( 'value' => '44', 'text' => '44px' ),
			array( 'value' => '46', 'text' => '46px' ),
			array( 'value' => '48', 'text' => '48px' ),
			array( 'value' => '50', 'text' => '50px' ),
			array( 'value' => '52', 'text' => '52px' ),
			array( 'value' => '54', 'text' => '54px' ),
			array( 'value' => '56', 'text' => '56px' ),
			array( 'value' => '58', 'text' => '58px' ),
			array( 'value' => '60', 'text' => '60px' )
		);
		
		$options['font_styles'] = array(
			array( 'value' => '', 'text' => esc_html__('None (default)', 'otw_pctp') ),
			array( 'value' => 'regular', 'text' => esc_html__('Regular', 'otw_pctp') ),
			array( 'value' => 'bold', 'text' => esc_html__('Bold', 'otw_pctp') ),
			array( 'value' => 'italic', 'text' => esc_html__('Italic', 'otw_pctp') ),
			array( 'value' => 'bold_italic', 'text' => esc_html__('Bold and Italic', 'otw_pctp') )
		);
		
		$options['alignments'] = array(
			array( 'value' => 'left', 'text' => esc_html__( 'Left (default)', 'otw_pctp' ) ),
			array( 'value' => 'right', 'text' => esc_html__( 'Right', 'otw_pctp' ) ),
			array( 'value' => 'center', 'text' => esc_html__( 'Center', 'otw_pctp' ) )
		);
		
		return $options;
	}
}

/** get custom templates
  *
  */
 if( !function_exists( 'otw_get_post_templates' ) ){
	
	function otw_get_post_templates(){
	
		$custom_templates = otw_get_post_custom_templates();
		
		$post_templates = array();
		
		if( is_array( $custom_templates ) && count( $custom_templates ) ){
		
			$post_templates['-'] = '-';
			
			foreach( $custom_templates as $custom_template ){
				$post_templates['otw_custom_template_'.$custom_template['id'] ] = $custom_template['title'];
				
				if( empty( $custom_template['title'] ) ){
					$post_templates['otw_custom_template_'.$custom_template['id'] ] = esc_html__( 'No title', 'otw_pctp' );
				}
			}
		}
		
		return $post_templates;
	}
	
}
/** get custom templates
  *
  */
 if( !function_exists( 'otw_get_post_custom_templates' ) ){
	
	function otw_get_post_custom_templates(){
		
		$otw_custom_templates = get_option( 'otw_mb_custom_templates' );
		
		if( !is_array( $otw_custom_templates ) || !count( $otw_custom_templates ) ){
			
			$otw_custom_templates = array();
			
		}
		return $otw_custom_templates;
	}
}

/** get custom templates next id
  *
  */
 if( !function_exists( 'otw_get_next_post_custom_template_id' ) ){
	
	function otw_get_next_post_custom_template_id(){
		
		$next_id = 1;
		$existing_custom_templates = otw_get_post_custom_templates();
		
		if( is_array( $existing_custom_templates ) && count( $existing_custom_templates ) ){
		
			foreach( $existing_custom_templates as $key => $s_data ){
				
				if( preg_match( "/^([0-9]+)$/", $key, $matches ) ){
					
					if( $matches[1] > $next_id ){
						$next_id = $matches[1];
					}
				}
			}
		}else{
			$next_id = 0;
		}
		return $next_id + 1;
		
	}
}

/**
 * Include admin scripts
 */
if( !function_exists( 'otw_pctp_enqueue_admin_scripts' ) ){
	
	function otw_pctp_enqueue_admin_scripts(){
		
		global $otw_pctp_grid_manager_object, $otw_pctp_shortcode_object, $otw_pctp_plugin_url, $otw_pctp_js_version;
		
		if( function_exists( 'get_current_screen' ) ){
			
			$screen = get_current_screen();
			
			if( isset( $screen->id ) && strlen( $screen->id ) ){
				$requested_page = $screen->id;
			}
		}
		
		if( preg_match( "/otw\-pctp\-(default|custom)\-templates\-(add|edit)$/", $requested_page ) || preg_match( "/otw\-pctp\-settings$/", $requested_page ) || ( $requested_page == 'post' ) ){
			
			$messages = array(
				'delete_confirm'  => esc_html__('Are you sure you want to delete ', 'otw_pctp'),
				'modal_title'     => esc_html__('Select Images', 'otw_pctp'),
				'modal_btn'       => esc_html__('Add Image', 'otw_pctp')
			);
			
			$otw_pctp_grid_manager_object->include_admin_scripts();
			$otw_pctp_shortcode_object->include_admin_scripts();
			wp_enqueue_style('thickbox');
			wp_enqueue_script('thickbox');
			wp_enqueue_script('media-models');
			wp_enqueue_script('media-upload');
			wp_enqueue_media();
			wp_enqueue_script( 'select2', $otw_pctp_plugin_url.'js/plugins/select2.full.min.js'  , array( 'jquery' ), $otw_pctp_js_version );
			wp_enqueue_script( 'otw_ptp_admin', $otw_pctp_plugin_url.'js/otw_pctp_admin.js'  , array( 'jquery', 'jquery-ui-sortable' ), $otw_pctp_js_version );
			
			wp_add_inline_script( 'otw_ptp_admin', 'var messages = "'.addslashes( json_encode( $messages ) ).'";', 'before' );
		}
	}
}

/**
 * include frontend styles
 */
if( !function_exists( 'otw_pctp_enqueue_styles' ) ){
	function otw_pctp_enqueue_styles(){
		global $otw_pctp_plugin_url, $otw_pctp_css_version, $otw_pctp_custom_css_path,  $otw_pctp_custom_css_url, $otw_pctp_js_version, $post, $otw_pctp_dispatcher;
		
		if( !is_admin() ){
			
			if( is_object( $otw_pctp_dispatcher ) && isset( $otw_pctp_dispatcher->is_used ) && $otw_pctp_dispatcher->is_used ){
				
				$count_views = false;
				
				if( is_object( $post ) && !wp_is_post_revision( $post ) && is_single() && !is_archive() && isset( $post->post_type ) && ( $post->post_type == 'post' ) ){
					$count_views = true;
				}
				
				global $wp_filesystem;
				
				if( otw_init_filesystem() ){
					
					if( $wp_filesystem->exists( $otw_pctp_custom_css_path ) ){
						
						wp_register_style('otw_pctp_custom.css', $otw_pctp_custom_css_url );
						wp_enqueue_style('otw_pctp_custom.css');
					}
				}
				wp_enqueue_style( 'otw-pct-font-awesome',  $otw_pctp_plugin_url.'css/font-awesome.min.css', array(), $otw_pctp_css_version );
				wp_enqueue_style( 'otw_pct', $otw_pctp_plugin_url.'css/otw_pctp.css', array(), $otw_pctp_css_version );
				
				$uniqueHash = wp_create_nonce("otw_pctp_social_share");
				$socialShareLink = admin_url( 'admin-ajax.php?action=otw_pctp_social_share&nonce='. $uniqueHash );
				
				wp_register_script( 'otw-pctp-flexslider', $otw_pctp_plugin_url.'js/jquery.flexslider.min.js', array( 'jquery' ), $otw_pctp_js_version );
				wp_register_script( 'otw-pctp-fancybox', $otw_pctp_plugin_url.'js/jquery.fancybox.min.js', array( 'jquery' ), $otw_pctp_js_version );
				wp_register_script( 'otw-pctp-imagesloaded', $otw_pctp_plugin_url.'js/imagesloaded.pkgd.min.js', array( 'jquery' ), $otw_pctp_js_version );
				
				wp_register_script( 'otw-pctp', $otw_pctp_plugin_url.'js/otw_pctp.js'  , array( 'jquery', 'jquery-ui-tabs' ), $otw_pctp_js_version );
				wp_add_inline_script( 'otw-pctp', 'var socialShareURL="'.esc_attr( $socialShareLink ).'";', 'before' );
				if( $count_views ){
					wp_register_script( 'otw-pctp-counter', $otw_pctp_plugin_url.'js/otw_pctp_counter.js', array( 'jquery' ), '', true );
					wp_add_inline_script( 'otw-pctp-counter', 'var otw_counter='. json_encode( array( 'url' => admin_url( 'admin-ajax.php' ), 'post_id' => $post->ID ) ).";", 'before' );
				}
				
				wp_enqueue_script( 'otw-pctp-flexslider' );
				wp_enqueue_script( 'otw-pctp-fancybox' );
				wp_enqueue_script( 'otw-pctp-imagesloaded' );
				wp_enqueue_script( 'otw-pctp' );
				
				if( $count_views ){
					wp_enqueue_script( 'otw-pctp-counter' );
				}
			}
		}
	}
}

/**
 * Include admin styles
 */
if( !function_exists( 'otw_pctp_enqueue_admin_styles' ) ){
	
	function otw_pctp_enqueue_admin_styles(){
	
		global $otw_pctp_grid_manager_object, $otw_pctp_shortcode_object, $otw_pctp_css_version, $otw_pctp_plugin_url;
		
		if( function_exists( 'get_current_screen' ) ){
			
			$screen = get_current_screen();
			
			if( isset( $screen->id ) && strlen( $screen->id ) ){
				$requested_page = $screen->id;
			}
		}
		
		if( preg_match( "/otw\-pctp\-(default|custom)\-templates\-(add|edit)$/", $requested_page ) || preg_match( "/otw\-pctp\-settings$/", $requested_page ) || preg_match( "/otw\-pctp$/", $requested_page ) || ( $requested_page == 'post' ) ){
			
			wp_enqueue_style( 'select2_admin', $otw_pctp_plugin_url.'css/select2.min.css' );
			wp_enqueue_style( 'otw_pctp_admin', $otw_pctp_plugin_url.'css/otw_pctp_admin.css', array( 'thickbox' ), $otw_pctp_css_version );
		}
	}
}

/**
 * Custom templates action
 */
if( !function_exists( 'otw_pctp_custom_templates_action' ) ){
	
	function otw_pctp_custom_templates_action(){
		
		global $otw_pctp_plugin_id, $otw_pctp_factory_object;
		
		if( !$otw_pctp_factory_object->is_plugin_active( $otw_pctp_plugin_id ) ){
			return;
		}
		
		$page_title = '';
		
		$otw_action = '';
		$custom_templates = otw_get_post_custom_templates();
		
		$confirm_text = '';
		$otw_custom_template_values = array();
		$otw_custom_template_values['title'] = esc_html__( 'N/A', 'otw_pctp' );
		
		if( otw_get('action',false) ){
			
			switch( otw_get('action','') ){
			
				case 'delete':
						$otw_action = 'delete_otw_pctp_custom_template';
						$page_title = esc_html__( 'Delete custom template', 'otw_pctp' );
						$confirm_text = esc_html__( 'Please confirm to delete the custom template', 'otw_pctp' );
						
						if( otw_get( 'custom_template', false ) && preg_match( "/^\d+$/", otw_get( 'custom_template', '' ) ) && intval( otw_get( 'custom_template', '' ) ) && array_key_exists( otw_get( 'custom_template', '' ), $custom_templates ) ){
							$otw_custom_template_values['title'] = $custom_templates[ otw_get( 'custom_template', '' ) ]['title'];
						}
					break;
				case 'copy':
						$otw_action = 'copy_otw_pctp_custom_template';
						$page_title = esc_html__( 'Duplicate custom template', 'otw_pctp' );
						$confirm_text = esc_html__( 'Please confirm to duplicate the custom template', 'otw_pctp' );
						
						if( otw_get( 'custom_template', false ) && preg_match( "/^\d+$/", otw_get( 'custom_template', '' ) ) && intval( otw_get( 'custom_template', '' ) ) && array_key_exists( otw_get( 'custom_template', '' ), $custom_templates ) ){
							$otw_custom_template_values['title'] = $custom_templates[ otw_get( 'custom_template', '' ) ]['title'];
						}
					break;
				default:
					    $page_title = esc_html__( 'Invalid action', 'otw_pctp' );
					break;
			}
		}else{
			$page_title = esc_html__( 'Invalid action', 'otw_pctp' );
		}
		
		require_once( 'otw_pctp_custom_templates_action.php');
	}
	
}


/**
 * Fonts array
 */
if( !function_exists( 'otw_pctp_fonts_array(' ) ){
	
	function otw_pctp_fonts_array(){
		
		return json_decode( '[{"id":0,"text":"Arial"},{"id":1,"text":"Arial Black"},{"id":2,"text":"Comic Sans"},{"id":3,"text":"Georgia"},{"id":4,"text":"Impact"},{"id":5,"text":"Lucida Console"},{"id":6,"text":"Lucida Sans Unicode"},{"id":7,"text":"Tahoma"},{"id":8,"text":"Times New Roman"},{"id":9,"text":"Verdana"},{"id":10,"text":"ABeeZee"},{"id":11,"text":"Abel"},{"id":12,"text":"Abril Fatface"},{"id":13,"text":"Aclonica"},{"id":14,"text":"Acme"},{"id":15,"text":"Actor"},{"id":16,"text":"Adamina"},{"id":17,"text":"Advent Pro"},{"id":18,"text":"Aguafina Script"},{"id":19,"text":"Akronim"},{"id":20,"text":"Aladin"},{"id":21,"text":"Aldrich"},{"id":22,"text":"Alef"},{"id":23,"text":"Alegreya"},{"id":24,"text":"Alegreya SC"},{"id":25,"text":"Alegreya Sans"},{"id":26,"text":"Alegreya Sans SC"},{"id":27,"text":"Alex Brush"},{"id":28,"text":"Alfa Slab One"},{"id":29,"text":"Alice"},{"id":30,"text":"Alike"},{"id":31,"text":"Alike Angular"},{"id":32,"text":"Allan"},{"id":33,"text":"Allerta"},{"id":34,"text":"Allerta Stencil"},{"id":35,"text":"Allura"},{"id":36,"text":"Almendra"},{"id":37,"text":"Almendra Display"},{"id":38,"text":"Almendra SC"},{"id":39,"text":"Amarante"},{"id":40,"text":"Amaranth"},{"id":41,"text":"Amatic SC"},{"id":42,"text":"Amethysta"},{"id":43,"text":"Anaheim"},{"id":44,"text":"Andada"},{"id":45,"text":"Andika"},{"id":46,"text":"Angkor"},{"id":47,"text":"Annie Use Your Telescope"},{"id":48,"text":"Anonymous Pro"},{"id":49,"text":"Antic"},{"id":50,"text":"Antic Didone"},{"id":51,"text":"Antic Slab"},{"id":52,"text":"Anton"},{"id":53,"text":"Arapey"},{"id":54,"text":"Arbutus"},{"id":55,"text":"Arbutus Slab"},{"id":56,"text":"Architects Daughter"},{"id":57,"text":"Archivo Black"},{"id":58,"text":"Archivo Narrow"},{"id":59,"text":"Arimo"},{"id":60,"text":"Arizonia"},{"id":61,"text":"Armata"},{"id":62,"text":"Artifika"},{"id":63,"text":"Arvo"},{"id":64,"text":"Asap"},{"id":65,"text":"Asset"},{"id":66,"text":"Astloch"},{"id":67,"text":"Asul"},{"id":68,"text":"Atomic Age"},{"id":69,"text":"Aubrey"},{"id":70,"text":"Audiowide"},{"id":71,"text":"Autour One"},{"id":72,"text":"Average"},{"id":73,"text":"Average Sans"},{"id":74,"text":"Averia Gruesa Libre"},{"id":75,"text":"Averia Libre"},{"id":76,"text":"Averia Sans Libre"},{"id":77,"text":"Averia Serif Libre"},{"id":78,"text":"Bad Script"},{"id":79,"text":"Balthazar"},{"id":80,"text":"Bangers"},{"id":81,"text":"Basic"},{"id":82,"text":"Battambang"},{"id":83,"text":"Baumans"},{"id":84,"text":"Bayon"},{"id":85,"text":"Belgrano"},{"id":86,"text":"Belleza"},{"id":87,"text":"BenchNine"},{"id":88,"text":"Bentham"},{"id":89,"text":"Berkshire Swash"},{"id":90,"text":"Bevan"},{"id":91,"text":"Bigelow Rules"},{"id":92,"text":"Bigshot One"},{"id":93,"text":"Bilbo"},{"id":94,"text":"Bilbo Swash Caps"},{"id":95,"text":"Bitter"},{"id":96,"text":"Black Ops One"},{"id":97,"text":"Bokor"},{"id":98,"text":"Bonbon"},{"id":99,"text":"Boogaloo"},{"id":100,"text":"Bowlby One"},{"id":101,"text":"Bowlby One SC"},{"id":102,"text":"Brawler"},{"id":103,"text":"Bree Serif"},{"id":104,"text":"Bubblegum Sans"},{"id":105,"text":"Bubbler One"},{"id":106,"text":"Buda"},{"id":107,"text":"Buenard"},{"id":108,"text":"Butcherman"},{"id":109,"text":"Butterfly Kids"},{"id":110,"text":"Cabin"},{"id":111,"text":"Cabin Condensed"},{"id":112,"text":"Cabin Sketch"},{"id":113,"text":"Caesar Dressing"},{"id":114,"text":"Cagliostro"},{"id":115,"text":"Calligraffitti"},{"id":116,"text":"Cambo"},{"id":117,"text":"Candal"},{"id":118,"text":"Cantarell"},{"id":119,"text":"Cantata One"},{"id":120,"text":"Cantora One"},{"id":121,"text":"Capriola"},{"id":122,"text":"Cardo"},{"id":123,"text":"Carme"},{"id":124,"text":"Carrois Gothic"},{"id":125,"text":"Carrois Gothic SC"},{"id":126,"text":"Carter One"},{"id":127,"text":"Caudex"},{"id":128,"text":"Cedarville Cursive"},{"id":129,"text":"Ceviche One"},{"id":130,"text":"Changa One"},{"id":131,"text":"Chango"},{"id":132,"text":"Chau Philomene One"},{"id":133,"text":"Chela One"},{"id":134,"text":"Chelsea Market"},{"id":135,"text":"Chenla"},{"id":136,"text":"Cherry Cream Soda"},{"id":137,"text":"Cherry Swash"},{"id":138,"text":"Chewy"},{"id":139,"text":"Chicle"},{"id":140,"text":"Chivo"},{"id":141,"text":"Cinzel"},{"id":142,"text":"Cinzel Decorative"},{"id":143,"text":"Clicker Script"},{"id":144,"text":"Coda"},{"id":145,"text":"Coda Caption"},{"id":146,"text":"Codystar"},{"id":147,"text":"Combo"},{"id":148,"text":"Comfortaa"},{"id":149,"text":"Coming Soon"},{"id":150,"text":"Concert One"},{"id":151,"text":"Condiment"},{"id":152,"text":"Content"},{"id":153,"text":"Contrail One"},{"id":154,"text":"Convergence"},{"id":155,"text":"Cookie"},{"id":156,"text":"Copse"},{"id":157,"text":"Corben"},{"id":158,"text":"Courgette"},{"id":159,"text":"Cousine"},{"id":160,"text":"Coustard"},{"id":161,"text":"Covered By Your Grace"},{"id":162,"text":"Crafty Girls"},{"id":163,"text":"Creepster"},{"id":164,"text":"Crete Round"},{"id":165,"text":"Crimson Text"},{"id":166,"text":"Croissant One"},{"id":167,"text":"Crushed"},{"id":168,"text":"Cuprum"},{"id":169,"text":"Cutive"},{"id":170,"text":"Cutive Mono"},{"id":171,"text":"Damion"},{"id":172,"text":"Dancing Script"},{"id":173,"text":"Dangrek"},{"id":174,"text":"Dawning of a New Day"},{"id":175,"text":"Days One"},{"id":176,"text":"Delius"},{"id":177,"text":"Delius Swash Caps"},{"id":178,"text":"Delius Unicase"},{"id":179,"text":"Della Respira"},{"id":180,"text":"Denk One"},{"id":181,"text":"Devonshire"},{"id":182,"text":"Didact Gothic"},{"id":183,"text":"Diplomata"},{"id":184,"text":"Diplomata SC"},{"id":185,"text":"Domine"},{"id":186,"text":"Donegal One"},{"id":187,"text":"Doppio One"},{"id":188,"text":"Dorsa"},{"id":189,"text":"Dosis"},{"id":190,"text":"Dr Sugiyama"},{"id":191,"text":"Droid Sans"},{"id":192,"text":"Droid Sans Mono"},{"id":193,"text":"Droid Serif"},{"id":194,"text":"Duru Sans"},{"id":195,"text":"Dynalight"},{"id":196,"text":"EB Garamond"},{"id":197,"text":"Eagle Lake"},{"id":198,"text":"Eater"},{"id":199,"text":"Economica"},{"id":200,"text":"Electrolize"},{"id":201,"text":"Elsie"},{"id":202,"text":"Elsie Swash Caps"},{"id":203,"text":"Emblema One"},{"id":204,"text":"Emilys Candy"},{"id":205,"text":"Engagement"},{"id":206,"text":"Englebert"},{"id":207,"text":"Enriqueta"},{"id":208,"text":"Erica One"},{"id":209,"text":"Esteban"},{"id":210,"text":"Euphoria Script"},{"id":211,"text":"Ewert"},{"id":212,"text":"Exo"},{"id":213,"text":"Exo 2"},{"id":214,"text":"Expletus Sans"},{"id":215,"text":"Fanwood Text"},{"id":216,"text":"Fascinate"},{"id":217,"text":"Fascinate Inline"},{"id":218,"text":"Faster One"},{"id":219,"text":"Fasthand"},{"id":220,"text":"Fauna One"},{"id":221,"text":"Federant"},{"id":222,"text":"Federo"},{"id":223,"text":"Felipa"},{"id":224,"text":"Fenix"},{"id":225,"text":"Finger Paint"},{"id":226,"text":"Fjalla One"},{"id":227,"text":"Fjord One"},{"id":228,"text":"Flamenco"},{"id":229,"text":"Flavors"},{"id":230,"text":"Fondamento"},{"id":231,"text":"Fontdiner Swanky"},{"id":232,"text":"Forum"},{"id":233,"text":"Francois One"},{"id":234,"text":"Freckle Face"},{"id":235,"text":"Fredericka the Great"},{"id":236,"text":"Fredoka One"},{"id":237,"text":"Freehand"},{"id":238,"text":"Fresca"},{"id":239,"text":"Frijole"},{"id":240,"text":"Fruktur"},{"id":241,"text":"Fugaz One"},{"id":242,"text":"GFS Didot"},{"id":243,"text":"GFS Neohellenic"},{"id":244,"text":"Gabriela"},{"id":245,"text":"Gafata"},{"id":246,"text":"Galdeano"},{"id":247,"text":"Galindo"},{"id":248,"text":"Gentium Basic"},{"id":249,"text":"Gentium Book Basic"},{"id":250,"text":"Geo"},{"id":251,"text":"Geostar"},{"id":252,"text":"Geostar Fill"},{"id":253,"text":"Germania One"},{"id":254,"text":"Gilda Display"},{"id":255,"text":"Give You Glory"},{"id":256,"text":"Glass Antiqua"},{"id":257,"text":"Glegoo"},{"id":258,"text":"Gloria Hallelujah"},{"id":259,"text":"Goblin One"},{"id":260,"text":"Gochi Hand"},{"id":261,"text":"Gorditas"},{"id":262,"text":"Goudy Bookletter 1911"},{"id":263,"text":"Graduate"},{"id":264,"text":"Grand Hotel"},{"id":265,"text":"Gravitas One"},{"id":266,"text":"Great Vibes"},{"id":267,"text":"Griffy"},{"id":268,"text":"Gruppo"},{"id":269,"text":"Gudea"},{"id":270,"text":"Habibi"},{"id":271,"text":"Hammersmith One"},{"id":272,"text":"Hanalei"},{"id":273,"text":"Hanalei Fill"},{"id":274,"text":"Handlee"},{"id":275,"text":"Hanuman"},{"id":276,"text":"Happy Monkey"},{"id":277,"text":"Headland One"},{"id":278,"text":"Henny Penny"},{"id":279,"text":"Herr Von Muellerhoff"},{"id":280,"text":"Holtwood One SC"},{"id":281,"text":"Homemade Apple"},{"id":282,"text":"Homenaje"},{"id":283,"text":"IM Fell DW Pica"},{"id":284,"text":"IM Fell DW Pica SC"},{"id":285,"text":"IM Fell Double Pica"},{"id":286,"text":"IM Fell Double Pica SC"},{"id":287,"text":"IM Fell English"},{"id":288,"text":"IM Fell English SC"},{"id":289,"text":"IM Fell French Canon"},{"id":290,"text":"IM Fell French Canon SC"},{"id":291,"text":"IM Fell Great Primer"},{"id":292,"text":"IM Fell Great Primer SC"},{"id":293,"text":"Iceberg"},{"id":294,"text":"Iceland"},{"id":295,"text":"Imprima"},{"id":296,"text":"Inconsolata"},{"id":297,"text":"Inder"},{"id":298,"text":"Indie Flower"},{"id":299,"text":"Inika"},{"id":300,"text":"Irish Grover"},{"id":301,"text":"Istok Web"},{"id":302,"text":"Italiana"},{"id":303,"text":"Italianno"},{"id":304,"text":"Jacques Francois"},{"id":305,"text":"Jacques Francois Shadow"},{"id":306,"text":"Jim Nightshade"},{"id":307,"text":"Jockey One"},{"id":308,"text":"Jolly Lodger"},{"id":309,"text":"Josefin Sans"},{"id":310,"text":"Josefin Slab"},{"id":311,"text":"Joti One"},{"id":312,"text":"Judson"},{"id":313,"text":"Julee"},{"id":314,"text":"Julius Sans One"},{"id":315,"text":"Junge"},{"id":316,"text":"Jura"},{"id":317,"text":"Just Another Hand"},{"id":318,"text":"Just Me Again Down Here"},{"id":319,"text":"Kameron"},{"id":320,"text":"Kantumruy"},{"id":321,"text":"Karla"},{"id":322,"text":"Kaushan Script"},{"id":323,"text":"Kavoon"},{"id":324,"text":"Kdam Thmor"},{"id":325,"text":"Keania One"},{"id":326,"text":"Kelly Slab"},{"id":327,"text":"Kenia"},{"id":328,"text":"Khmer"},{"id":329,"text":"Kite One"},{"id":330,"text":"Knewave"},{"id":331,"text":"Kotta One"},{"id":332,"text":"Koulen"},{"id":333,"text":"Kranky"},{"id":334,"text":"Kreon"},{"id":335,"text":"Kristi"},{"id":336,"text":"Krona One"},{"id":337,"text":"La Belle Aurore"},{"id":338,"text":"Lancelot"},{"id":339,"text":"Lato"},{"id":340,"text":"League Script"},{"id":341,"text":"Leckerli One"},{"id":342,"text":"Ledger"},{"id":343,"text":"Lekton"},{"id":344,"text":"Lemon"},{"id":345,"text":"Libre Baskerville"},{"id":346,"text":"Life Savers"},{"id":347,"text":"Lilita One"},{"id":348,"text":"Lily Script One"},{"id":349,"text":"Limelight"},{"id":350,"text":"Linden Hill"},{"id":351,"text":"Lobster"},{"id":352,"text":"Lobster Two"},{"id":353,"text":"Londrina Outline"},{"id":354,"text":"Londrina Shadow"},{"id":355,"text":"Londrina Sketch"},{"id":356,"text":"Londrina Solid"},{"id":357,"text":"Lora"},{"id":358,"text":"Love Ya Like A Sister"},{"id":359,"text":"Loved by the King"},{"id":360,"text":"Lovers Quarrel"},{"id":361,"text":"Luckiest Guy"},{"id":362,"text":"Lusitana"},{"id":363,"text":"Lustria"},{"id":364,"text":"Macondo"},{"id":365,"text":"Macondo Swash Caps"},{"id":366,"text":"Magra"},{"id":367,"text":"Maiden Orange"},{"id":368,"text":"Mako"},{"id":369,"text":"Marcellus"},{"id":370,"text":"Marcellus SC"},{"id":371,"text":"Marck Script"},{"id":372,"text":"Margarine"},{"id":373,"text":"Marko One"},{"id":374,"text":"Marmelad"},{"id":375,"text":"Marvel"},{"id":376,"text":"Mate"},{"id":377,"text":"Mate SC"},{"id":378,"text":"Maven Pro"},{"id":379,"text":"McLaren"},{"id":380,"text":"Meddon"},{"id":381,"text":"MedievalSharp"},{"id":382,"text":"Medula One"},{"id":383,"text":"Megrim"},{"id":384,"text":"Meie Script"},{"id":385,"text":"Merienda"},{"id":386,"text":"Merienda One"},{"id":387,"text":"Merriweather"},{"id":388,"text":"Merriweather Sans"},{"id":389,"text":"Metal"},{"id":390,"text":"Metal Mania"},{"id":391,"text":"Metamorphous"},{"id":392,"text":"Metrophobic"},{"id":393,"text":"Michroma"},{"id":394,"text":"Milonga"},{"id":395,"text":"Miltonian"},{"id":396,"text":"Miltonian Tattoo"},{"id":397,"text":"Miniver"},{"id":398,"text":"Miss Fajardose"},{"id":399,"text":"Modern Antiqua"},{"id":400,"text":"Molengo"},{"id":401,"text":"Molle"},{"id":402,"text":"Monda"},{"id":403,"text":"Monofett"},{"id":404,"text":"Monoton"},{"id":405,"text":"Monsieur La Doulaise"},{"id":406,"text":"Montaga"},{"id":407,"text":"Montez"},{"id":408,"text":"Montserrat"},{"id":409,"text":"Montserrat Alternates"},{"id":410,"text":"Montserrat Subrayada"},{"id":411,"text":"Moul"},{"id":412,"text":"Moulpali"},{"id":413,"text":"Mountains of Christmas"},{"id":414,"text":"Mouse Memoirs"},{"id":415,"text":"Mr Bedfort"},{"id":416,"text":"Mr Dafoe"},{"id":417,"text":"Mr De Haviland"},{"id":418,"text":"Mrs Saint Delafield"},{"id":419,"text":"Mrs Sheppards"},{"id":420,"text":"Muli"},{"id":421,"text":"Mystery Quest"},{"id":422,"text":"Neucha"},{"id":423,"text":"Neuton"},{"id":424,"text":"New Rocker"},{"id":425,"text":"News Cycle"},{"id":426,"text":"Niconne"},{"id":427,"text":"Nixie One"},{"id":428,"text":"Nobile"},{"id":429,"text":"Nokora"},{"id":430,"text":"Norican"},{"id":431,"text":"Nosifer"},{"id":432,"text":"Nothing You Could Do"},{"id":433,"text":"Noticia Text"},{"id":434,"text":"Noto Sans"},{"id":435,"text":"Noto Serif"},{"id":436,"text":"Nova Cut"},{"id":437,"text":"Nova Flat"},{"id":438,"text":"Nova Mono"},{"id":439,"text":"Nova Oval"},{"id":440,"text":"Nova Round"},{"id":441,"text":"Nova Script"},{"id":442,"text":"Nova Slim"},{"id":443,"text":"Nova Square"},{"id":444,"text":"Numans"},{"id":445,"text":"Nunito"},{"id":446,"text":"Odor Mean Chey"},{"id":447,"text":"Offside"},{"id":448,"text":"Old Standard TT"},{"id":449,"text":"Oldenburg"},{"id":450,"text":"Oleo Script"},{"id":451,"text":"Oleo Script Swash Caps"},{"id":452,"text":"Open Sans"},{"id":453,"text":"Open Sans Condensed"},{"id":454,"text":"Oranienbaum"},{"id":455,"text":"Orbitron"},{"id":456,"text":"Oregano"},{"id":457,"text":"Orienta"},{"id":458,"text":"Original Surfer"},{"id":459,"text":"Oswald"},{"id":460,"text":"Over the Rainbow"},{"id":461,"text":"Overlock"},{"id":462,"text":"Overlock SC"},{"id":463,"text":"Ovo"},{"id":464,"text":"Oxygen"},{"id":465,"text":"Oxygen Mono"},{"id":466,"text":"PT Mono"},{"id":467,"text":"PT Sans"},{"id":468,"text":"PT Sans Caption"},{"id":469,"text":"PT Sans Narrow"},{"id":470,"text":"PT Serif"},{"id":471,"text":"PT Serif Caption"},{"id":472,"text":"Pacifico"},{"id":473,"text":"Paprika"},{"id":474,"text":"Parisienne"},{"id":475,"text":"Passero One"},{"id":476,"text":"Passion One"},{"id":477,"text":"Pathway Gothic One"},{"id":478,"text":"Patrick Hand"},{"id":479,"text":"Patrick Hand SC"},{"id":480,"text":"Patua One"},{"id":481,"text":"Paytone One"},{"id":482,"text":"Peralta"},{"id":483,"text":"Permanent Marker"},{"id":484,"text":"Petit Formal Script"},{"id":485,"text":"Petrona"},{"id":486,"text":"Philosopher"},{"id":487,"text":"Piedra"},{"id":488,"text":"Pinyon Script"},{"id":489,"text":"Pirata One"},{"id":490,"text":"Plaster"},{"id":491,"text":"Play"},{"id":492,"text":"Playball"},{"id":493,"text":"Playfair Display"},{"id":494,"text":"Playfair Display SC"},{"id":495,"text":"Podkova"},{"id":496,"text":"Poiret One"},{"id":497,"text":"Poller One"},{"id":498,"text":"Poly"},{"id":499,"text":"Pompiere"},{"id":500,"text":"Pontano Sans"},{"id":501,"text":"Port Lligat Sans"},{"id":502,"text":"Port Lligat Slab"},{"id":503,"text":"Prata"},{"id":504,"text":"Preahvihear"},{"id":505,"text":"Press Start 2P"},{"id":506,"text":"Princess Sofia"},{"id":507,"text":"Prociono"},{"id":508,"text":"Prosto One"},{"id":509,"text":"Puritan"},{"id":510,"text":"Purple Purse"},{"id":511,"text":"Quando"},{"id":512,"text":"Quantico"},{"id":513,"text":"Quattrocento"},{"id":514,"text":"Quattrocento Sans"},{"id":515,"text":"Questrial"},{"id":516,"text":"Quicksand"},{"id":517,"text":"Quintessential"},{"id":518,"text":"Qwigley"},{"id":519,"text":"Racing Sans One"},{"id":520,"text":"Radley"},{"id":521,"text":"Raleway"},{"id":522,"text":"Raleway Dots"},{"id":523,"text":"Rambla"},{"id":524,"text":"Rammetto One"},{"id":525,"text":"Ranchers"},{"id":526,"text":"Rancho"},{"id":527,"text":"Rationale"},{"id":528,"text":"Redressed"},{"id":529,"text":"Reenie Beanie"},{"id":530,"text":"Revalia"},{"id":531,"text":"Ribeye"},{"id":532,"text":"Ribeye Marrow"},{"id":533,"text":"Righteous"},{"id":534,"text":"Risque"},{"id":535,"text":"Roboto"},{"id":536,"text":"Roboto Condensed"},{"id":537,"text":"Roboto Slab"},{"id":538,"text":"Rochester"},{"id":539,"text":"Rock Salt"},{"id":540,"text":"Rokkitt"},{"id":541,"text":"Romanesco"},{"id":542,"text":"Ropa Sans"},{"id":543,"text":"Rosario"},{"id":544,"text":"Rosarivo"},{"id":545,"text":"Rouge Script"},{"id":546,"text":"Ruda"},{"id":547,"text":"Rufina"},{"id":548,"text":"Ruge Boogie"},{"id":549,"text":"Ruluko"},{"id":550,"text":"Rum Raisin"},{"id":551,"text":"Ruslan Display"},{"id":552,"text":"Russo One"},{"id":553,"text":"Ruthie"},{"id":554,"text":"Rye"},{"id":555,"text":"Sacramento"},{"id":556,"text":"Sail"},{"id":557,"text":"Salsa"},{"id":558,"text":"Sanchez"},{"id":559,"text":"Sancreek"},{"id":560,"text":"Sansita One"},{"id":561,"text":"Sarina"},{"id":562,"text":"Satisfy"},{"id":563,"text":"Scada"},{"id":564,"text":"Schoolbell"},{"id":565,"text":"Seaweed Script"},{"id":566,"text":"Sevillana"},{"id":567,"text":"Seymour One"},{"id":568,"text":"Shadows Into Light"},{"id":569,"text":"Shadows Into Light Two"},{"id":570,"text":"Shanti"},{"id":571,"text":"Share"},{"id":572,"text":"Share Tech"},{"id":573,"text":"Share Tech Mono"},{"id":574,"text":"Shojumaru"},{"id":575,"text":"Short Stack"},{"id":576,"text":"Siemreap"},{"id":577,"text":"Sigmar One"},{"id":578,"text":"Signika"},{"id":579,"text":"Signika Negative"},{"id":580,"text":"Simonetta"},{"id":581,"text":"Sintony"},{"id":582,"text":"Sirin Stencil"},{"id":583,"text":"Six Caps"},{"id":584,"text":"Skranji"},{"id":585,"text":"Slackey"},{"id":586,"text":"Smokum"},{"id":587,"text":"Smythe"},{"id":588,"text":"Sniglet"},{"id":589,"text":"Snippet"},{"id":590,"text":"Snowburst One"},{"id":591,"text":"Sofadi One"},{"id":592,"text":"Sofia"},{"id":593,"text":"Sonsie One"},{"id":594,"text":"Sorts Mill Goudy"},{"id":595,"text":"Source Code Pro"},{"id":596,"text":"Source Sans Pro"},{"id":597,"text":"Special Elite"},{"id":598,"text":"Spicy Rice"},{"id":599,"text":"Spinnaker"},{"id":600,"text":"Spirax"},{"id":601,"text":"Squada One"},{"id":602,"text":"Stalemate"},{"id":603,"text":"Stalinist One"},{"id":604,"text":"Stardos Stencil"},{"id":605,"text":"Stint Ultra Condensed"},{"id":606,"text":"Stint Ultra Expanded"},{"id":607,"text":"Stoke"},{"id":608,"text":"Strait"},{"id":609,"text":"Sue Ellen Francisco"},{"id":610,"text":"Sunshiney"},{"id":611,"text":"Supermercado One"},{"id":612,"text":"Suwannaphum"},{"id":613,"text":"Swanky and Moo Moo"},{"id":614,"text":"Syncopate"},{"id":615,"text":"Tangerine"},{"id":616,"text":"Taprom"},{"id":617,"text":"Tauri"},{"id":618,"text":"Telex"},{"id":619,"text":"Tenor Sans"},{"id":620,"text":"Text Me One"},{"id":621,"text":"The Girl Next Door"},{"id":622,"text":"Tienne"},{"id":623,"text":"Tinos"},{"id":624,"text":"Titan One"},{"id":625,"text":"Titillium Web"},{"id":626,"text":"Trade Winds"},{"id":627,"text":"Trocchi"},{"id":628,"text":"Trochut"},{"id":629,"text":"Trykker"},{"id":630,"text":"Tulpen One"},{"id":631,"text":"Ubuntu"},{"id":632,"text":"Ubuntu Condensed"},{"id":633,"text":"Ubuntu Mono"},{"id":634,"text":"Ultra"},{"id":635,"text":"Uncial Antiqua"},{"id":636,"text":"Underdog"},{"id":637,"text":"Unica One"},{"id":638,"text":"UnifrakturCook"},{"id":639,"text":"UnifrakturMaguntia"},{"id":640,"text":"Unkempt"},{"id":641,"text":"Unlock"},{"id":642,"text":"Unna"},{"id":643,"text":"VT323"},{"id":644,"text":"Vampiro One"},{"id":645,"text":"Varela"},{"id":646,"text":"Varela Round"},{"id":647,"text":"Vast Shadow"},{"id":648,"text":"Vibur"},{"id":649,"text":"Vidaloka"},{"id":650,"text":"Viga"},{"id":651,"text":"Voces"},{"id":652,"text":"Volkhov"},{"id":653,"text":"Vollkorn"},{"id":654,"text":"Voltaire"},{"id":655,"text":"Waiting for the Sunrise"},{"id":656,"text":"Wallpoet"},{"id":657,"text":"Walter Turncoat"},{"id":658,"text":"Warnes"},{"id":659,"text":"Wellfleet"},{"id":660,"text":"Wendy One"},{"id":661,"text":"Wire One"},{"id":662,"text":"Yanone Kaffeesatz"},{"id":663,"text":"Yellowtail"},{"id":664,"text":"Yeseva One"},{"id":665,"text":"Yesteryear"},{"id":666,"text":"Zeyada"}]' );
	}
}
/**
 * Select2 options
 */
if( !function_exists( 'otw_pctp_select2_options' ) ){
	
	function otw_pctp_select2_options(){
		
		$options = array();
		$options['results'] = array();
		
		$options_type = '';
		$options_limit = 100;
		
		if( otw_post( 'otw_options_type', false ) ){
			$options_type = otw_post( 'otw_options_type', '' );
		}
		
		if( otw_post( 'otw_options_limit', false ) ){
			$options_limit = otw_post( 'otw_options_limit', '' );
		}
		
		switch( $options_type ){
			
			case 'fonts':
					$allFonts = otw_pctp_fonts_array();
					
					$include_items = array();
					
					if( otw_post( 'otw_options_ids', false ) && strlen( otw_post( 'otw_options_ids', '' ) ) ){
						$include_items = explode( ',', otw_post( 'otw_options_ids', '' ) );
					}
					
					foreach( $allFonts as $font ){
						
						$o_key = count( $options['results'] );
						
						if( !count( $include_items ) || in_array( $font->id, $include_items ) ){
							$options['results'][ $o_key ] = array();
							$options['results'][ $o_key ]['id'] = $font->id;
							$options['results'][ $o_key ]['text'] = $font->text;
						}
					
					}
				break;
			case 'category':
					$args = array();
					$args['hide_empty']      = 0;
					$args['number']          = $options_limit;
					
					if( otw_post( 'otw_options_ids', false ) && strlen( otw_post( 'otw_options_ids', '' ) ) ){
						
						$args['include'] = array();
						$include_items = explode( ',', otw_post( 'otw_options_ids', '' ) );
						
						foreach( $include_items as $i_item ){
							
							if( intval( $i_item ) ){
								$args['include'][] = $i_item;
							}
						}
					}
					
					if( otw_post( 'otw_options_search', false ) && strlen( otw_post( 'otw_options_search', '' ) ) ){
						$args['search'] = urldecode( otw_post( 'otw_options_search', '' ) );
					}
					
					$all_items = get_categories( $args );
					
					if( is_array( $all_items ) && count( $all_items ) ){
						foreach( $all_items as $item ){
							$o_key = count( $options['results'] );
							$options['results'][ $o_key ] = array();
							$options['results'][ $o_key ]['id'] = $item->term_id;
							$options['results'][ $o_key ]['text'] = $item->name;
						}
					}
				break;
			case 'post':
					$args = array();
					$args['post_type'] = 'post';
					$args['number']          = $options_limit;
					
					if( otw_post( 'otw_options_ids', false ) && strlen( otw_post( 'otw_options_ids', '' ) ) ){
						
						$args['post__in'] = array();
						$include_items = explode( ',', otw_post( 'otw_options_ids', '' ) );
						
						foreach( $include_items as $i_item ){
							
							if( intval( $i_item ) ){
								$args['post__in'][] = $i_item;
							}
						}
					}
					
					if( otw_post( 'otw_options_search', false ) && strlen( otw_post( 'otw_options_search', '' ) ) ){
						$args['s'] = urldecode( otw_post( 'otw_options_search', '' ) );
					}
					
					$query = new WP_Query( $args );
					$all_items = $query->posts;
					
					if( is_array( $all_items ) && count( $all_items ) ){
						foreach( $all_items as $item ){
							$o_key = count( $options['results'] );
							$options['results'][ $o_key ] = array();
							$options['results'][ $o_key ]['id'] = $item->ID;
							$options['results'][ $o_key ]['text'] = $item->post_title;
						}
					}
				break;
		}
		
		echo json_encode( $options );
		die;
	}
}

/**
 * post category table
 */
if( !function_exists( 'otw_pctp_category_template_table' ) ){
	
	function otw_pctp_category_template_table(){
		
		global $wp_registered_sidebars;
		
		$html = '';
		
		if( otw_post( 'object', false ) && otw_post( 'action', false ) && otw_post( 'action', '' ) == 'otw_pctp_category_template_table' ){
		
			$json_object = json_decode( otw_stripslashes( otw_post( 'object', '' ) ) );
			
			if( gettype( $json_object ) == 'array' ){
			
				$templates = array( 'default' => esc_html__( 'Theme\'s default template (default)', 'otw_pctp' ) ) + otw_get_post_templates();
			
				$html .= "\n<div class=\"otw_ct_table_holder\">";
				
				foreach( $json_object as $row_id => $row ){
				
					if( intval( $row->category ) && isset( $templates[ $row->template ] ) ){
						
						$cat_info = get_category( $row->category );
						
						if( $cat_info->term_id ){
							$html .= "\n<div id=\"otw_ct_row_".$row_id."\" class=\"otw_ct_row\">";
							$html .= "\n<div class=\"otw_ct_cell1\">".$cat_info->name."</div>";
							$html .= "\n<div class=\"otw_ct_cell2\">".$templates[ $row->template ]."</div>";
							$html .= "\n<div class=\"otw_ct_cell3\">";
							
							if( isset( $row->sidebar ) && isset( $wp_registered_sidebars[ $row->sidebar ] ) ){
								$html .= $wp_registered_sidebars[ $row->sidebar ]['name'];
							}else{
								$html .= '&nbsp;';
							}
							$html .= "</div>";
							$html .= "\n<div class=\"otw_ct_cell4\"><a href=\"javascript:;\" class=\"otw_ct_delete\">".__( 'Delete', 'otw_pctp' )."</a></div>";
							$html .= "\n</div>";
						}
					}
				}
				
				$html .= "\n</table>";
			}
		}
		
		echo $html;
		die;
	}
}

function otw_pctp_post_template(){

	global $post, $otw_pctp_grid_manager_object, $otw_pctp_dispatcher;
	
	if( is_single() && !is_archive() && isset( $post->post_type ) && ( $post->post_type == 'post' ) ){
	
		include_once( 'classes/otw_pctp_dispatcher.class.php' );
		
		$otw_pctp_dispatcher = new OTW_PCTP_Dispatcher();
		$otw_pctp_dispatcher->views_path = dirname(  __FILE__ ).'/views/';
		$otw_pctp_dispatcher->grid_manager_component_object = $otw_pctp_grid_manager_object;
		$otw_pctp_dispatcher->buildPostTemplate( $post );
	}
}

/**
 * meta boxes
 */
if( !function_exists( 'otw_pctp_meta_boxes' ) ){
	
	function otw_pctp_meta_boxes(){
		
		if( !defined( 'OTW_PLUGIN_BLOG_MANAGER' ) || !OTW_PLUGIN_BLOG_MANAGER ){
			add_meta_box( 'otw-bm-meta-box', esc_html__('OTW Media Item', 'otw_pctp'), 'otw_pctp_media_meta_box', 'post', 'normal', 'default' );
		}
		add_meta_box( 'otw-mbp-options-meta-box',__('Post Template Selection', 'otw_pctp'), 'otw_pctp_options_meta_box', 'post', 'normal', 'default' );
		add_meta_box( 'otw-mbp-tabs-meta-box', esc_html__('OTW Post Tabs', 'otw_pctp'), 'otw_pctp_tabs_meta_box', 'post', 'normal', 'default' );
		add_meta_box( 'otw-mbp-otw_related_posts-meta-box', esc_html__('OTW Related Posts', 'otw_pctp'), 'otw_pctp_related_posts_meta_box', 'post', 'normal', 'default' );
		add_meta_box( 'otw-mbp-reviews-meta-box', esc_html__('Post Reviews', 'otw_pctp'), 'otw_pctp_reviews_meta_box', 'post', 'normal', 'default' );
		add_meta_box( 'otw-mbp-custom-fields-meta-box', esc_html__('OTW Post Fields', 'otw_pctp'), 'otw_pctp_custom_fields_meta_box', 'post', 'normal', 'default' );
	}
}

/**
 * media meta boxes
 */
if( !function_exists( 'otw_pctp_media_meta_box' ) ){
	
	function otw_pctp_media_meta_box( $post ){
	    
		$otw_meta_data = get_post_meta( $post->ID, 'otw_bm_meta_data', true );
		
		require_once( 'otw_pctp_media_meta_box.php');
	}
}

/**
 * Add related posts metabox
 */
if( !function_exists( 'otw_pctp_related_posts_meta_box' ) ){
	
	function otw_pctp_related_posts_meta_box( $post ){
		
		$otw_related_posts = otw_pctp_get_post_related_posts( $post->ID );
		
		require_once( 'otw_pctp_related_posts_meta_box.php' );
	}
}

/**
 * Get related posts
 */
if( !function_exists( 'otw_pctp_get_post_related_posts' ) ){
	
	function otw_pctp_get_post_related_posts( $post_id ){
		
		$related_posts = '';
		
		if( $post_id ){
			
			$db_related_posts = get_post_meta( $post_id, 'otw_mb_related_posts', true );
			$related_posts_array = array();
			
			if( strlen( trim( $db_related_posts ) )  ){
				
				$db_related_posts_array = explode( ',', $db_related_posts );
				
				foreach( $db_related_posts_array as $r_post ){
					
					if( intval( $r_post ) ){
						$related_posts_array[ $r_post ] = $r_post;
					}
				}
			}
			
			if( count( $related_posts_array  ) ){
				$related_posts = implode( ',', $related_posts_array  );
			}
		}
		return $related_posts;
	}
}

/**
 * reviews meta boxes
 */
if( !function_exists( 'otw_pctp_reviews_meta_box' ) ){
	
	
	function otw_pctp_reviews_meta_box( $post ){
		
		$otw_mb_reviews_meta_data = get_post_meta( $post->ID, 'otw_mb_reviews_meta_data', true );
		
		$total_reviews = 0;
		
		if( is_array( $otw_mb_reviews_meta_data ) ){
		
			ksort( $otw_mb_reviews_meta_data );
			
			foreach( $otw_mb_reviews_meta_data as $key => $value ){
			
				if( otw_post( 'otw_mb_review_title', false ) && otw_post( array( 'otw_mb_review_title', $key ), false ) ){
					$otw_mb_reviews_meta_data[ $key ]['title'] = otw_post( array( 'otw_mb_review_title', $key ), array() );
				}
				if( otw_post( 'otw_mb_review_rate', false ) && otw_post( array( 'otw_mb_review_rate', $key ), false ) ){
					$otw_mb_reviews_meta_data[ $key ]['rate'] = otw_post( array( 'otw_mb_review_rate', $key ), array() );
				}
			}
			
			$total_reviews = count( $otw_mb_reviews_meta_data );
		}
		
		require_once( 'otw_pctp_reviews_meta_box.php' );
	}
	
}

/**
 * custom fields meta boxes
 */
if( !function_exists( 'otw_pctp_custom_fields_meta_box' ) ){
	
	function otw_pctp_custom_fields_meta_box( $post ){
		
		$otw_post_custom_fields_meta_data = get_post_meta( $post->ID, 'otw_post_custom_fields_meta_data', true );
		
		$total_post_custom_fields = 0;
		
		
		if( is_array( $otw_post_custom_fields_meta_data ) && count( $otw_post_custom_fields_meta_data ) ){
			
			uasort( $otw_post_custom_fields_meta_data, 'otw_pctp_sort_custom_fields' );
			
			foreach( $otw_post_custom_fields_meta_data as $key => $value ){
			
				if( otw_post( 'otw_post_custom_field_title', false ) && otw_post( array( 'otw_post_custom_field_title', $key ), false ) ){
					$otw_post_custom_fields_meta_data[ $key ]['title'] = otw_post( array( 'otw_post_custom_field_title', $key ), array() );
				}
				if( otw_post( 'otw_post_custom_field_description', false ) && otw_post( array( 'otw_post_custom_field_description', $key ), false ) ){
					$otw_post_custom_fields_meta_data[ $key ]['description'] = otw_post( array( 'otw_post_custom_field_description', $key ), array() );
				}
			}
			
			$total_post_custom_fields = count( $otw_post_custom_fields_meta_data );
		}
		
		require_once( 'otw_pctp_custom_fields_meta_box.php' );
	}
	
}

/**
 * custom fields meta boxes
 */
if( !function_exists( 'otw_pctp_sort_custom_fields' ) ){
	
	function otw_pctp_sort_custom_fields( $a, $b ){
		
		if( $a['order'] > $b['order'] ){
			return 1;
		}
		elseif( $a['order'] < $b['order'] ){
			return -1;
		}
		return 0;
	}
	
}

/**
 * tabs meta boxes
 */
if( !function_exists( 'otw_pctp_tabs_meta_box' ) ){
	
	function otw_pctp_tabs_meta_box( $post ){
		
		$otw_pct_tabs_meta_data = get_post_meta( $post->ID, 'otw_mb_tabs_meta_data', true );
		
		$total_tabs = 0;
		
		if( is_array( $otw_pct_tabs_meta_data ) ){
		
			ksort( $otw_pct_tabs_meta_data );
			
			foreach( $otw_pct_tabs_meta_data as $key => $value ){
			
				if( otw_post( 'otw_mb_tab_title', false ) && otw_post( array( 'otw_mb_tab_title', $key ), false ) ){
					$otw_pct_tabs_meta_data[ $key ]['title'] = otw_post( array( 'otw_mb_tab_title', $key ), array() );
				}
				if( otw_post( 'otw_mb_tab_content', false ) && otw_post( array( 'otw_mb_tab_content', $key ), false ) ){
					$otw_pct_tabs_meta_data[ $key ]['content'] = otw_post( array( 'otw_mb_tab_content', $key ), array() );
				}
			}
			
			$total_tabs = count( $otw_pct_tabs_meta_data );
		}
		
		require_once( 'otw_pctp_tabs_meta_box.php');
	}
}

/**
 * options meta box
 */
if( !function_exists( 'otw_pctp_options_meta_box' ) ){
	
	function otw_pctp_options_meta_box( $post ){
		
		$otw_pct_options_meta_data_db = get_post_meta( $post->ID, 'otw_mb_options_meta_data', true );
		
		if( !is_array( $otw_pct_options_meta_data_db ) || !isset( $otw_pct_options_meta_data_db ) ){
			$otw_pct_options_meta_data = array();
			$otw_pct_options_meta_data['otw_pct_options_type'] = 'default';
			$otw_pct_options_meta_data['options'] = array();
		}else{
			$otw_pct_options_meta_data = array();
			
			if( isset( $otw_pct_options_meta_data_db['otw_pct_options_type'] ) ){
				
				$otw_pct_options_meta_data['otw_pct_options_type'] = $otw_pct_options_meta_data_db['otw_pct_options_type'];
			}else{
				$otw_pct_options_meta_data['otw_pct_options_type'] = 'default';
			}
			$otw_pct_options_meta_data['options'] = array();
			
			foreach( $otw_pct_options_meta_data_db['options'] as $setting_key => $setting_value )
			{
				$otw_pct_options_meta_data['options'][ $setting_key ] = $setting_value;
			}
		}
		
		$otw_pct_templates = array( 'default' => esc_html__( 'Default Theme\'s Post Template', 'otw_pctp' ) ) + otw_get_post_templates();
		
		$otw_pct_options_meta_data['options'] = otw_pctp_get_settings( $otw_pct_options_meta_data['options'] );
		
		$otw_pct_social_icons = array(
			'' => esc_html__( 'None (default)', 'otw_pctp' ),
			'share_icons' => esc_html__( 'Share Icons', 'otw_pctp' ),
			'share_btn_small' => esc_html__( 'Share Buttons Small', 'otw_pctp' ),
			'share_btn_large' => esc_html__( 'Share Buttons Large', 'otw_pctp' ),
			'like_buttons' => esc_html__( 'Like Buttons', 'otw_pctp' )
		);
		
		$otw_pct_prev_next_nav_options = array(
			'' => esc_html__( 'No (default)', 'otw_pctp' ),
			'yes' => esc_html__( 'Yes', 'otw_pctp' )
		);
		
		$otw_pct_related_posts_options = array(
			'' => esc_html__( 'No (default)', 'otw_pctp' ),
			'yes' => esc_html__( 'Yes', 'otw_pctp' )
		);
		
		$otw_pct_related_posts_criteria_options = array(
			'category' => esc_html__( 'Category (default)', 'otw_pctp' ),
			'post_tag' => esc_html__( 'Tag', 'otw_pctp' ),
			'handpicked' => esc_html__( 'Handpicked', 'otw_pctp' )
		);
		
		$otw_pct_social_icons_options =array(
			array( 'value' => '0', 'text' => esc_html__('None (default)', 'otw_pctp') ),
			array( 'value' => 'share_icons', 'text' => esc_html__('Share Icons', 'otw_pctp') ),
			array( 'value' => 'share_btn_small', 'text' => esc_html__('Share Buttons Small', 'otw_pctp') ),
			array( 'value' => 'share_btn_large', 'text' => esc_html__('Share Buttons Large', 'otw_pctp') ),
			array( 'value' => 'like_buttons', 'text' => esc_html__('Like Buttons', 'otw_pctp') ),
			array( 'value' => 'custom_icons', 'text' => esc_html__('Custom Social Icons', 'otw_pctp') )
		);
		
		$otw_pct_item_media_format_options = array(
			'' => esc_html__('Keep original file format (default)', 'otw_pctp' ),
			'jpg' => 'jpg',
			'png' => 'png',
			'gif' => 'gif'
		);
		
		$otw_pct_media_lightbox_options = array(
			'yes' => esc_html__( 'Yes (default)', 'otw_pctp' ),
			'no' => esc_html__( 'No', 'otw_pctp' )
		);
		
		$total_meta_elements = 6;
		
		$meta_elements = array();
		$meta_elements['author']  = esc_html__( 'author', 'otw_pctp' );
		$meta_elements['date'] = esc_html__( 'date', 'otw_pctp' );
		$meta_elements['category'] = esc_html__( 'category', 'otw_pctp' );
		$meta_elements['tags'] = esc_html__( 'tags', 'otw_pctp' );
		$meta_elements['comments'] = esc_html__( 'comments', 'otw_pctp' );
		$meta_elements['views'] = esc_html__( 'Post Visits', 'otw_pctp' );
		
		$meta_elements_height = ( ( $total_meta_elements + 2 ) * 22 );
		
		$selectMetaData = array(
			array( 'value' => 'horizontal', 'text' => esc_html__('Horizontal (default)', 'otw_pctp') ),
			array( 'value' => 'vertical', 'text' => esc_html__('Vertical', 'otw_pctp') ),
		);
		
		require_once( 'otw_pctp_options_meta_box.php');
	}
}

/**
 * save media meta boxes
 */
if( !function_exists( 'otw_pctp_save_meta_box' ) ){
	
	function otw_pctp_save_meta_box( $post_id ){
	
		if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
			return;
		}
		
		if( !empty( $_POST ) && !empty( otw_post( 'otw-bm-list-media_type', '' )) ){

			
			$otw_meta_data = array(
				'media_type'      => otw_post( 'otw-bm-list-media_type', '' ),
				'youtube_url'     => otw_post( 'otw-bm-list-youtube_url', '' ),
				'vimeo_url'       => otw_post( 'otw-bm-list-vimeo_url', '' ),
				'soundcloud_url'  => otw_post( 'otw-bm-list-soundcloud_url', '' ),
				'img_url'         => otw_post( 'otw-bm-list-img_url', '' ),
				'slider_url'      => otw_post( 'otw-bm-list-slider_url', '' )
			);
			
			/**
				* Add Custom POST Meta Data
				* If POST is found in the DB it will just be ignored and return FALSE
			*/
			add_post_meta($post_id, 'otw_bm_meta_data', $otw_meta_data, true);
			
			// If POST is in the DB update it
			update_post_meta($post_id, 'otw_bm_meta_data', $otw_meta_data);
		}elseif( !empty( $_POST ) &&  otw_post( 'otw-bm-list-media_type', false )  ){
			delete_post_meta($post_id, 'otw_bm_meta_data');
		}
		
		//save options metaboxs
		if( !empty( $_POST ) && !empty( otw_post( 'otw_pctp_meta_options', '' )) ){
			
			$otw_options_meta = array();
			
			$otw_options_meta['otw_pct_options_type'] = otw_post('otw_pct_options_type');
			$otw_options_meta['options'] = array();
			
			$mb_settings = otw_pctp_get_settings();
			
			foreach( $mb_settings as $otw_setting_key => $default_setting_value )
			{
				if( otw_post( $otw_setting_key, false ) ){
					$otw_options_meta['options'][ $otw_setting_key ] = otw_post( $otw_setting_key, '' );
				}
			}
			
			add_post_meta($post_id, 'otw_mb_options_meta_data', $otw_options_meta, true);
			
			update_post_meta($post_id, 'otw_mb_options_meta_data', $otw_options_meta );
		}
		
		//save tabs meta box
		if( otw_post('otw_pct_meta_tabs', false ) ){
			
			$otw_tabs_meta = array();
			
			if( $post_titles = otw_post( 'otw_mb_tab_title', false ) ){
				
				foreach( $post_titles as $new_id => $new_title ){
				
					if( strlen( trim( $new_title ) ) || strlen( trim( otw_post( array( 'otw_mb_tab_content', $new_id ), array() ) ) ) ){
					
						$otw_tabs_meta[] = array( 
							'title' => $new_title,
							'content' => otw_post( array( 'otw_mb_tab_content', $new_id ), array() )
						);
					}
				}
			}
			
			add_post_meta($post_id, 'otw_mb_tabs_meta_data', $otw_tabs_meta, true);
			
			update_post_meta($post_id, 'otw_mb_tabs_meta_data', $otw_tabs_meta );
		}
		
		//reviews
		if( otw_post('otw_pct_meta_reviews', false ) ){
			
			$otw_reviews_meta = array();
			
			if( $post_titles = otw_post( 'otw_mb_review_title', false ) ){
				
				foreach( $post_titles as $new_id => $new_title ){
				
					if( strlen( trim( $new_title ) ) && strlen( trim( otw_post( array( 'otw_mb_review_rate', $new_id ), array() ) ) ) ){
					
						$otw_reviews_meta[] = array( 
							'title' => $new_title,
							'rate' => otw_post( array( 'otw_mb_review_rate', $new_id ), array() )
						);
					}
				}
			}
			
			add_post_meta($post_id, 'otw_mb_reviews_meta_data', $otw_reviews_meta, true);
			
			update_post_meta($post_id, 'otw_mb_reviews_meta_data', $otw_reviews_meta );
		}
		
		//post custom fields
		if( otw_post( 'otw_pct_meta_post_custom_fields', false ) ){
			
			$otw_post_custom_fields_meta = array();
			
			if( $post_titles = otw_post( 'otw_post_custom_field_title', false ) ){
				
				foreach( $post_titles as $new_id => $new_title ){
					
					if( strlen( trim( $new_title ) ) || strlen( trim( otw_post( array( 'otw_post_custom_field_description', $new_id ), array() ) ) ) ){
						$new_key = count( $otw_post_custom_fields_meta );
						$otw_post_custom_fields_meta[ $new_key ] = array();
						$otw_post_custom_fields_meta[ $new_key ]['title'] = $new_title;
						
						$otw_post_custom_fields_meta[ $new_key ]['description'] = otw_post( array( 'otw_post_custom_field_description', $new_id ), array() );
						$otw_post_custom_fields_meta[ $new_key ]['order'] = otw_post( array( 'otw_post_custom_field_order', $new_id ), array() );
					}
				}
			}
			
			add_post_meta($post_id, 'otw_post_custom_fields_meta_data', $otw_post_custom_fields_meta, true);
			
			update_post_meta($post_id, 'otw_post_custom_fields_meta_data', $otw_post_custom_fields_meta );
		}
		
		//related posts
		if( otw_post( 'otw_pctp_otw_related_posts', false ) ){
			
			$key_name = 'otw_mb_related_posts';
			
			if( otw_post( 'otw_replated_posts', false ) && strlen( trim( otw_post( 'otw_replated_posts', '' ) ) ) ){
				add_post_meta($post_id, $key_name, otw_post( 'otw_replated_posts', '' ), true);
				update_post_meta($post_id, $key_name, otw_post( 'otw_replated_posts', '' ) );
			}else{
				delete_post_meta($post_id, $key_name );
			}
		}
	}
}

if( !function_exists( 'otw_pctp_social_share' ) ){
	
	function otw_pctp_social_share(){
		
		include( 'otw_pctp_social_shares.php' );
		
		if( otw_post( 'url', false )  && otw_post( 'url', '' ) != '' && filter_var(otw_post( 'url', '' ), FILTER_VALIDATE_URL) ){
			$url = otw_post( 'url', '' );
			$otw_social_shares = new otw_social_shares($url);
			
			echo $otw_social_shares->otw_get_shares();
		} else {
			echo json_encode(array('info' => 'error', 'msg' => 'URL is not valid!'));
		}
		exit;
	}
}

if( !function_exists( 'otw_pctp_get_video' ) ){
	
	function otw_pctp_get_video(){
		
		$post_id = 0;
		
		if( otw_get( 'post_id', false ) && intval( otw_get( 'post_id', '' ) ) ){
			$post_id = otw_get( 'post_id', '' );
			$list_id = 0;
			
			$view_type = '';
			
			if( otw_get( 'vr', false ) && (  otw_get( 'vr', '' ) == 'item_media' ) ){
				$view_type =  otw_get( 'vr', '' );
			}
			elseif( otw_get( 'vr', false ) && (  otw_get( 'vr', '' ) == 'list_media' ) ){
			
				if( otw_get( 'list_id', false ) && intval( otw_get( 'list_id', '' ) ) ){
					$list_id = otw_get( 'list_id', '' );
					$view_type =  otw_get( 'vr', '' );
				}
			}
			
			if( $post_id ){
				$post = get_post( $post_id );
				
				if( isset( $post->ID ) && ( $post->post_type == 'post' ) ){
					
					$postMetaData = get_post_meta( $post->ID, 'otw_bm_meta_data', true );
					
					if( $view_type == 'item_media' ){
						
						include_once( 'classes/otw_pctp_dispatcher.class.php' );
						$otw_pctp_dispatcher = new OTW_PCTP_Dispatcher();
						
						$videoWidth = '1024';
						$videoHeight = '640';
						
						$item_options = get_post_meta( $post->ID, 'otw_pct_options_meta_data', true );
						
						if( isset( $item_options['otw_pct_options_type'] ) && ( $item_options['otw_pct_options_type'] == 'custom' ) ){
							
							if( isset( $item_options['options'] ) ){
							
								if( isset( $item_options['options']['otw_pct_item_media_lightbox_width'] ) && strlen( $item_options['options']['otw_pct_item_media_lightbox_width'] ) ){
									$videoWidth = $item_options['options']['otw_pct_item_media_lightbox_width'];
								}
								
								if( isset( $item_options['options']['otw_pct_item_media_lightbox_height'] ) && strlen( $item_options['options']['otw_pct_item_media_lightbox_height'] ) ){
									$videoHeight = $item_options['options']['otw_pct_item_media_lightbox_height'];
								}
							}
						}else{
							$plugin_options = otw_pctp_get_options();
							
							if( isset( $plugin_options['otw_pct_item_media_lightbox_width'] ) && strlen( $plugin_options['otw_pct_item_media_lightbox_width'] ) ){
								$videoWidth = $plugin_options['otw_pct_item_media_lightbox_width'];
							}
							
							if( isset( $plugin_options['otw_pct_item_media_lightbox_height'] ) && strlen( $plugin_options['otw_pct_item_media_lightbox_height'] ) ){
								$videoHeight = $plugin_options['otw_pct_item_media_lightbox_height'];
							}
						}
					}
					
					
					if( isset( $postMetaData['media_type'] ) ){
					
						switch( $postMetaData['media_type'] ){
						
							case 'youtube':
									if( !empty( $postMetaData['youtube_url'] ) ){
										
										if( in_array( $view_type, array( 'item_media', 'list_media' ) ) ){
											echo $otw_pctp_dispatcher->otwEmbedResize( wp_oembed_get($postMetaData['youtube_url'], array('width' => $videoWidth)), $videoWidth, $videoHeight, 'center_center' );
										}else{
											echo wp_oembed_get( $postMetaData['youtube_url'] );
										}
										die;
									}
								break;
							case 'vimeo':
									if( !empty( $postMetaData['vimeo_url'] ) ){
										
										if( in_array( $view_type, array( 'item_media', 'list_media' ) ) ){
											echo $otw_pctp_dispatcher->otwEmbedResize( wp_oembed_get($postMetaData['vimeo_url'], array('width' => $videoWidth)), $videoWidth, $videoHeight, 'center_center' );
										}else{
											echo wp_oembed_get( $postMetaData['vimeo_url'] );
										}
										die;
									}
								break;
							case 'soundcloud':
									if( !empty( $postMetaData['soundcloud_url'] ) ){
										
										if( in_array( $view_type, array( 'item_media', 'list_media' ) ) ){
											echo $otw_pctp_dispatcher->otwEmbedResize( wp_oembed_get($postMetaData['soundcloud_url'], array('width' => $videoWidth)), $videoWidth, $videoHeight, 'center_center' );
										}else{
											echo wp_oembed_get( $postMetaData['soundcloud_url'] );
										}
										die;
									}
								break;
						}
					}
				}
			}
			
		}
		_e( 'Video not found', 'otw_pctp' );
		die;
	}
}
if( !function_exists( 'otw_pctp_get_options' ) ){
	
	function otw_pctp_get_options(){
		
		$otw_pct_plugin_options = otw_pctp_get_settings();
		
		$db_otw_pct_plugin_options = get_option( 'otw_mb_plugin_options' );
		
		
		foreach( $otw_pct_plugin_options as $key => $value ){
		
			if( is_array( $db_otw_pct_plugin_options ) && isset( $db_otw_pct_plugin_options[ $key ] ) ){
			
				$otw_pct_plugin_options[ $key ] = $db_otw_pct_plugin_options[ $key ];
			}
		}
		
		return $otw_pct_plugin_options;
	}
}

/**
 * Register custom sidebars
 */
if( !function_exists( 'otw_pctp_register_predefined_templates' ) ){
	
	function otw_pctp_register_predefined_templates(){
		
		include_once( 'otw_pctp_predefined_templates.php' );
		
		if( is_array( $otw_pctp_predefined_templates ) && count( $otw_pctp_predefined_templates ) ){
		
			global $otw_pctp_template_custom_css_path;
			
			$custom_template_mapping = array();
			
			$otw_custom_templates = get_option( 'otw_mb_custom_templates' );
			
			if( is_array( $otw_custom_templates ) && count( $otw_custom_templates ) ){
				
				foreach( $otw_custom_templates as $template ){
					
					if( isset( $template['pdf_id'] ) && strlen( $template['pdf_id'] ) ){
						
						$custom_template_mapping[ $template['pdf_id'] ] = $template['id'];
					}
				}
			}
			
			global $wp_filesystem;
			
			foreach( $otw_pctp_predefined_templates as $pp_id => $pp_template ){
			
				$decoded = unserialize( base64_decode( $pp_template ) );
				
				
				if( isset( $decoded['grid_content'] ) ){
					
					$decoded['grid_content'] = addslashes( $decoded['grid_content'] );
					
					if( isset( $custom_template_mapping[ $pp_id ] ) ){
					
					}else{
						
						$otw_custom_template_id = otw_get_next_post_custom_template_id();
						
						$otw_custom_templates[ $otw_custom_template_id ] = $decoded;
						$otw_custom_templates[ $otw_custom_template_id ]['id'] = $otw_custom_template_id;
						$otw_custom_templates[ $otw_custom_template_id ]['pdf_id'] = $pp_id;
						
						if( isset( $decoded['_custom_css'] ) && strlen( $decoded['_custom_css'] ) ){
						
							$decoded['_custom_css'] = str_replace( 'otw_pct_ct_'.$decoded['id'], 'otw_pct_ct_'.$otw_custom_template_id, $decoded['_custom_css'] );
							
							$file_name = $otw_pctp_template_custom_css_path.'otw_pct_ct_'.$otw_custom_template_id.'.css';
							
							if( otw_init_filesystem() ){
								$wp_filesystem->put_contents( $file_name, $decoded['_custom_css'] );
							}
							
							unset( $otw_custom_templates[ $otw_custom_template_id ]['_custom_css'] );
						}
						update_option( 'otw_mb_custom_templates', $otw_custom_templates );
					}
				}
			}
		}
	}
}
/**
 * Register custom sidebars
 */
if( !function_exists( 'otw_pctp_register_custom_sidebars' ) ){
	
	function otw_pctp_register_custom_sidebars(){
		
		$args = array();
		$args['id'] = 'otw_pctp_sidebar_0';
		$args['name'] = esc_html__( 'OTW Post Custom Templates', 'otw_pctp' );
		$args['description'] = '';
		$args['before_widget'] = '<div id="%1$s" class="widget %2$s">';
		$args['after_widget'] = '</div>';
		
		register_sidebar( $args );
	}
}

/**
 * Count post previews
 */
if( !function_exists( 'otw_pctp_count_post_previews' ) ){
	
	function otw_pctp_count_post_previews(){
		
		if( otw_post( 'post_id', false ) && intval( otw_post( 'post_id', '' ) ) ){
			
			$post = get_post( otw_post( 'post_id', '' ) );
			
			if( isset( $post->ID ) && ( $post->ID ) ){
				
				$current_count = get_post_meta( $post->ID, 'otw_cpp', true );
				
				if( !$current_count || !intval( $current_count ) ){
					$current_count = 0;
				}
				$current_count++;
				
				update_post_meta( $post->ID, 'otw_cpp', $current_count );
				
			}
		}
		
		die;
	}
}

if( !function_exists( 'otw_pctp_factory_message' ) ){
	
	function otw_pctp_factory_message( $params ){
		
		global $otw_pctp_plugin_id;
		
		if( isset( $params['plugin'] ) && $otw_pctp_plugin_id == $params['plugin'] ){
			
			//filter out some messages if need it
		}
		if( isset( $params['message'] ) )
		{
			return $params['message'];
		}
		return $params;
	}
}