<?php
/**
 * Plugin Name: Post Custom Templates
 * Plugin URI: http://OTWthemes.com 
 * Description: Post Custom Templates will help you in changing your theme's default demplate for single posts. You can also create custom templates - drag & drop, no codding.
 * Author: OTWthemes.com
 * Version: 1.17
 * Author URI: https://codecanyon.net/user/otwthemes/portfolio?ref=OTWthemes
 */
load_plugin_textdomain('otw_pctp',false,dirname(plugin_basename(__FILE__)) . '/languages/');

$otw_pctp_plugin_id = '7f372ff6902310294960ade6ab940337';
$otw_pctp_plugin_url = plugin_dir_url( __FILE__);
$otw_pctp_js_version = '0.3';
$otw_pctp_css_version = '0.3';

$otw_pctp_dispatcher = false;

//include functions
require_once( plugin_dir_path( __FILE__ ).'/include/otw_pctp_functions.php' );

if( !defined( 'OTW_PLUGIN_POST_CUSTOM_TEMPLATES_PRO' ) ){
	define( 'OTW_PLUGIN_POST_CUSTOM_TEMPLATES_PRO', 1 );
}

$otw_pctp_custom_css_path = '';
$otw_pctp_custom_css_url = '';

$otw_pctp_template_custom_css_path = '';
$otw_pctp_template_custom_css_url = '';

$upload_dir = wp_upload_dir();

if( isset( $upload_dir['basedir'] ) ){
	$otw_pctp_custom_css_path = $upload_dir['basedir'].'/otwpct/custom.css';
	$otw_pctp_custom_css_url =  set_url_scheme( $upload_dir['baseurl'] ).'/otwpct/custom.css';

	$otw_pctp_template_custom_css_path = $upload_dir['basedir'].'/otwpct/';
	$otw_pctp_template_custom_css_url =  set_url_scheme( $upload_dir['baseurl'] ).'/otwpct/';
}

//load core component functions
include_once( 'include/otw_components/otw_functions/otw_functions.php' );

if( !function_exists( 'otw_register_component' ) ){
	wp_die( 'Please include otw components' );
}

otw_set_up_memory_limit( '512M' );

$otw_pctp_grid_manager_component = false;
$otw_pctp_grid_manager_object = false;
$otw_pctp_shortcode_component = false;
$otw_pctp_shortcode_object = false;
$otw_pctp_factory_component = false;
$otw_pctp_factory_object = false;
$otw_pctp_content_sidebars_component = false;
$otw_pctp_form_component = false;
$otw_pctp_form_object = false;
$otw_pctp_image_component = false;
$otw_pctp_image_object = false;
$otw_pctp_image_profile = false;
	

//register grid manager component
otw_register_component( 'otw_post_template_grid_manager', dirname( __FILE__ ).'/include/otw_components/otw_post_template_grid_manager/', $otw_pctp_plugin_url.'include/otw_components/otw_post_template_grid_manager/' );

//register shortcode component
otw_register_component( 'otw_post_template_shortcode', dirname( __FILE__ ).'/include/otw_components/otw_post_template_shortcode/', $otw_pctp_plugin_url.'include/otw_components/otw_post_template_shortcode/' );

//register factory component
otw_register_component( 'otw_factory', dirname( __FILE__ ).'/include/otw_components/otw_factory/', $otw_pctp_plugin_url.'/include/otw_components/otw_factory/' );

//register content sidebars component
otw_register_component( 'otw_content_sidebars', dirname( __FILE__ ).'/include/otw_components/otw_content_sidebars/', $otw_pctp_plugin_url.'include/otw_components/otw_content_sidebars/' );

//register form component
otw_register_component( 'otw_form', dirname( __FILE__ ).'/include/otw_components/otw_form/', $otw_pctp_plugin_url.'include/otw_components/otw_form/' );

//register image component
otw_register_component( 'otw_image', dirname( __FILE__ ).'/include/otw_components/otw_image/', '/include/otw_components/otw_image/' );

/** 
 *call init plugin function
 */
add_action('init', 'otw_pctp_init', 10000 );

if( is_admin() ){
	add_action( 'wp_ajax_otw_pctp_select2_options', 'otw_pctp_select2_options' );
	add_action( 'wp_ajax_otw_pctp_category_template_table', 'otw_pctp_category_template_table' );
	add_action( 'wp_ajax_otw_pctp_social_share', 'otw_pctp_social_share' );
	add_action( 'wp_ajax_nopriv_otw_pctp_social_share', 'otw_pctp_social_share' );
	add_action( 'wp_ajax_otw_pctp_get_video', 'otw_pctp_get_video' );
	add_action( 'wp_ajax_nopriv_otw_pctp_get_video', 'otw_pctp_get_video' );
	add_action( 'wp_ajax_otw_cpp', 'otw_pctp_count_post_previews' );
	add_action( 'wp_ajax_nopriv_otw_cpp', 'otw_pctp_count_post_previews' );
}else{
	add_action( 'template_redirect', 'otw_pctp_post_template', 1000000 );
}