<?php
class OTW_Post_Template_Grid_Manager extends OTW_Component{
	
	/**
	 * Name of the meta field
	 * 
	 * @var  string 
	 */
	public $meta_name = 'otw_post_template_grid_manager_content';
	
	/**
	 * Rreview shortcodes in the gird
	 */
	public $shortcode_preview_in_grid = false;
	
	/**
	 * post post id
	 */
	public $post_item_id = 0;
	
	/**
	 *  Numbers
	 *
	 *  @var array
	 */
	
	public $number_names = array( 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen', 'twenty', 'twentyone', 'twentytwo', 'twentythree', 'twentyfour');
	
	/** Grid size
	 *
	 *  @var integer
	 */
	
	public $grid_size = 24;
	
	/** Mobile grid size
	 *
	 *  @var integer
	 */
	
	private $mobile_grid_size = 6;
	
	/** Mobile grid columns
	 *
	 *  @var integer
	 */
	
	private $mobile_grid_columns = array( '1_1' => '1/1', '1_2' => '1/2', '1_3' => '1/3', '2_3' => '2/3');
	
	
	/**
	 * text info
	 */ 
	public $text_info = '';
	
	
	public function __construct(){
		
		if( is_admin() ){
			add_action( 'wp_ajax_otw_post_template_grid_manager_row_dialog', array( &$this, 'build_edit_row_dialog' ) );
			add_action( 'wp_ajax_otw_post_template_grid_manager_column_dialog', array( &$this, 'build_add_column_dialog' ) );
			add_action( 'wp_ajax_otw_post_template_grid_manager_save_template', array( &$this, 'otw_save_template' ) );
			add_action( 'wp_ajax_otw_post_template_grid_manager_delete_template', array( &$this, 'otw_delete_template' ) );
			add_action( 'wp_ajax_otw_post_template_grid_manager_load_template', array( &$this, 'otw_load_template' ) );
			
		}
		
		add_shortcode( 'otw_shortcode_post_template_grid_row', array( &$this, 'otw_shortcode_grid_row' ) );
		add_shortcode( 'otw_shortcode_post_template_grid_column', array( &$this, 'otw_shortcode_grid_column' ) );
		
		$this->text_info = $this->get_label('Add some rows and columns in the rows. Then you will be able to add items (actual content) in the columns.<br />You can clone every row or column with all content in it by clicking the Clone button for each row/column.<br />Once you build your layout you can save it so you can use it for another page.');
	}
	
	/**
	 *  Init 
	 */
	public function init(){
		
		if( is_admin() ){
			
			
		}elseif( !is_admin() ){
			
			if( method_exists( $this, 'add_lib' ) ){
				$this->add_lib( 'css', 'otw_grid_manager', $this->component_url.'css/otw-grid.css', 'front', 40, array() );
			}else{
				wp_enqueue_style( 'otw_grid_manager', $this->component_url.'css/otw-grid.css', array( ), $this->css_version );
			}
			
			wp_enqueue_script('otw_grid_manager', $this->component_url.'js/otw_post_template_grid_manager.js?' , array( 'jquery' ), $this->js_version );
			wp_enqueue_style( 'otw_grid_manager', $this->component_url.'css/otw-grid.css', array( ), $this->css_version );
		}
		
		parent::init();
	}
	
	
	/**
	 *  Render custom box content
	 */
	public function build_custom_box( $current_code ){
		
		$this->build_box( $current_code );
	}
	/**
	 *  Render meta box content
	 */
	public function build_meta_box(){
		
		global $post_id;
		
		$current_code = get_post_meta($post_id, $this->meta_name, TRUE);
		
		if( otw_post( array( '_'.$this->meta_name, 'code' ), false, array(), 'json' ) ){
			$current_code = otw_post( array( '_'.$this->meta_name, 'code' ), array(), array(), 'json' );
		}
		
		$this->build_box( $current_code );
	}
	
	private function build_box( $current_code )
	{
		global $post_id;
		
		//templates
		$templates = get_option( $this->meta_name.'_templates' );
		$js_templates = array();
		
		if( strlen( trim( $templates ) ) ){
			$templates_array = unserialize( $templates );
			
			if( is_array( $templates_array ) ){
				
				foreach( $templates_array as $template_key => $template ){
					$js_templates[] = array( $template_key, $template['name'] );
				}
			}
		
		}
		
		$content = "";
		
		$content .= "<div id=\"".$this->meta_name."_container\" class=\"otw_grid_manager_container\">";
		$content .= "\n<p class=\"otw_grid_manager_info\">";
		$content .= "<a href=\"javascript:;\" id=\"".$this->meta_name."_info_button\" class=\"otw_grid_manager_info_button\">".$this->get_label('Info')."</a>";
		$content .= "\n</p>"; 
		$content .= "\n<p>";
		$content .= "<a href=\"javascript:;\" id=\"".$this->meta_name."_add_row\" class=\"button button-small\">".$this->get_label('Add Row')."</a>&nbsp;";
		$content .= "<a href=\"javascript:;\" id=\"".$this->meta_name."_templates\" class=\"button button-small\">".$this->get_label('Templates')."</a>";
		$content .= "</p>";  
    $content .= "\n<p class=\"otw_grid_manager_info_block\" id=\"".$this->meta_name."_info_block\">";
		$content .= $this->text_info;
		
		$content .= "\n<div id=\"".$this->meta_name."_preview\" class=\"otw_grid_manager_content_preview\"></div>";
		$content .= "\n<input type=\"hidden\" id=\"".$this->meta_name."_code\" name=\"_".$this->meta_name."[code]\" value=\"".htmlentities( $current_code, ENT_QUOTES, "UTF-8")."\" />";
		$content .= "\n<input type=\"hidden\" name=\"".$this->meta_name."_noncename\" value=\"" . wp_create_nonce(__FILE__) . "\" />";
		
		$content .= "\n<script type=\"text/javascript\">";
		$content .= "\njQuery(document).ready(function(){
				otw_grid_manager_".$this->meta_name." = new otw_post_template_grid_manager_object( '".$this->meta_name."', ".json_encode( $this->labels ).", ".json_encode( $js_templates ).", '".$this->shortcode_preview_in_grid ."', '".$this->component_url."', 'admin-ajax', '".$post_id."' );";
		$content .= "\n});";
		$content .=  "\n</script>";
		$content .= "</div>";
		echo $content;
	}
	
	public function build_edit_row_dialog(){
	
		$source = array();
	
		$content = "";
		
		$content  = "\n<div style=\"min-height:100%; position:relative; overflow: hidden; background-color: #fff;\">";
		$content .= "\n<div class=\"otw-clear\" id=\"otw-row-editor-buttons\">
				<div class=\"alignleft\">
					<input type=\"button\" accesskey=\"C\" value=\"".$this->get_label('Cancel')."\" name=\"cancel\" class=\"button\" id=\"otw-row-editor-btn-cancel\">
				</div>
				<div class=\"alignright\">
					<input type=\"button\" accesskey=\"I\" value=\"".$this->get_label('Save')."\" name=\"insert\" class=\"button-primary\" id=\"otw-row-editor-btn-save\">
				</div>
				<div class=\"otw-clear\"></div>
				</div>";
		$content .= "<table cellspacing=\"2\" cellpadding=\"0\" class=\"otw-row-editor-body\">";
		
			$content .= "<tr>";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::select( array( 'id' => 'otw-row-element-stretch', 'label' => $this->get_label( 'Row Stretch' ), 'description' => $this->get_label( 'Select row stretch settings' ), 'options' => array( '' => $this->get_label( 'No Row Stretch (default)' ), 'stretch_r' => $this->get_label( 'Stretch Row' ), 'stretch_rc' => $this->get_label( 'Stretch Row and Content' ), 'stretch_rcnp' => $this->get_label( 'Stretch Row and Content(no padding)' ) ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr>";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::text_input( array( 'id' => 'otw-row-element-padding_top', 'label' => $this->get_label( 'Top Padding' ), 'description' => $this->get_label( 'This will add space on the top of your row content. Top Padding is in px.' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr>";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::text_input( array( 'id' => 'otw-row-element-padding_bottom', 'label' => $this->get_label( 'Bottom Padding' ), 'description' => $this->get_label( 'This will add space on the bottom of your row content. Bottom Padding is in px.' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr>";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::select( array( 'id' => 'otw-row-element-height', 'label' => $this->get_label( 'Height' ), 'description' => $this->get_label( 'Select row height.' ), 'options' => array( '' => $this->get_label( 'Content height (default)' ), 'full_top' => $this->get_label( 'Full - Content on Top' ), 'full_middle' => $this->get_label( 'Full - Content in the Middle' ), 'full_bottom' => $this->get_label( 'Full - Content at the Bottom' ) ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr>";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::select( array( 'id' => 'otw-row-element-background', 'label' => $this->get_label( 'Background' ), 'description' => $this->get_label( 'Select row background type.' ), 'options' => array( '' => $this->get_label( 'None' ), 'image' => $this->get_label( 'Image' ), 'video' => $this->get_label( 'Video' ), 'color' => $this->get_label( 'Background Color' ), 'animation_color' => $this->get_label( 'Background Color Animation' ), 'featured_image' => $this->get_label( 'Featured Image' ) ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-image\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::uploader( array( 'id' => 'otw-row-element-background_image', 'label' => $this->get_label( 'Image' ), 'description' => $this->get_label( 'Select image' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-image-size\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::select( array( 'id' => 'otw-row-element-background_image_size', 'label' => $this->get_label( 'Background Size' ), 'description' => $this->get_label( 'The Repeat option is good when you use a pattern. The Full option is good when you use a big image.' ), 'options' => array( 'cover' => $this->get_label( 'Full (default)' ), 'unset' => $this->get_label( 'Repeat' ) ), 'parse' => $source ) );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-video\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::text_input( array( 'id' => 'otw-row-element-background_video', 'label' => $this->get_label( 'Video Link' ), 'description' => $this->get_label( 'Add video url. Supports Youtube and Vimeo.' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-video-sound\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::select( array( 'id' => 'otw-row-element-background_video_sound', 'label' => $this->get_label( 'Video Sound' ), 'description' => $this->get_label( 'Sound on/off' ), 'options' => array( '0' => $this->get_label( 'Off(default)' ), '1' => $this->get_label( 'On' ) ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-video-repeat\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::select( array( 'id' => 'otw-row-element-background_video_repeat', 'label' => $this->get_label( 'Video play again' ), 'description' => $this->get_label( 'Automatically play video again after it finishes.' ), 'options' => array( 'yes' => $this->get_label( 'Yes(default)' ), 'no' => $this->get_label( 'No' ) ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-video-quality\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::select( array( 'id' => 'otw-row-element-background_video_quality', 'label' => $this->get_label( 'Video Quaity' ), 'description' => $this->get_label( 'Select video quality.' ), 'options' => array( 'auto' => $this->get_label( 'Auto(default)' ), 'highres' => $this->get_label( 'Highres' ), 'hd1080' => $this->get_label( '1080p HD' ), 'hd720' => $this->get_label( '720p HD' ), 'large' => $this->get_label( 'Large' ), 'medium' => $this->get_label( 'Medium' ), 'small' => $this->get_label( 'Small' ) ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-color\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::color_picker( array( 'id' => 'otw-row-element-background_color', 'label' => $this->get_label( 'Color' ), 'description' => $this->get_label( 'Select background color' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-color-animation-duration\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::text_input( array( 'id' => 'otw-row-element-background_color_animation_duration', 'label' => $this->get_label( 'Animation Duration' ), 'description' => $this->get_label( 'Choose the duration for the Background Color Animation.' ), 'parse' => $source, 'value' => 20 )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-color-animation-count\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::select( array( 'id' => 'otw-row-element-background_color_animation_count', 'label' => $this->get_label( 'Animation Iteration Count' ), 'description' => $this->get_label( 'The number of times the animation should be played.' ), 'parse' => $source, 'options' => array( 'infinite' => $this->get_label( 'Infinite(default)' ), '1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5' ) )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-color-animation-color0\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::color_picker( array( 'id' => 'otw-row-element-background_color_animation_color0', 'label' => $this->get_label( 'Color 0%' ), 'description' => $this->get_label( 'The color when the animation is 0% complete.' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-color-animation-color50\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::color_picker( array( 'id' => 'otw-row-element-background_color_animation_color50', 'label' => $this->get_label( 'Color 50%' ), 'description' => $this->get_label( 'The color when the animation is 50% complete.' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-color-animation-color100\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::color_picker( array( 'id' => 'otw-row-element-background_color_animation_color100', 'label' => $this->get_label( 'Color 100%' ), 'description' => $this->get_label( 'The color when the animation is 100% complete.' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-parallax\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::select( array( 'id' => 'otw-row-element-parallax', 'label' => $this->get_label( 'Parallax' ), 'description' => $this->get_label( 'Add parallax effect to the background.' ), 'options' => array( '' => $this->get_label( 'None(default)' ), 'simple' => $this->get_label( 'Simple' ), 'fade' => $this->get_label( 'Fade' ) ), 'pare' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-filter\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::select( array( 'id' => 'otw-row-element-background_filter', 'label' => $this->get_label( 'Background Filter' ), 'description' => $this->get_label( 'Select row background filter.' ), 'options' => array( '' => $this->get_label( 'No(default)' ), 'color' => $this->get_label( 'Color' ), 'gradient' => $this->get_label( 'Gradient' ) ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-filter-color\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::color_picker( array( 'id' => 'otw-row-element-background_filter_color', 'label' => $this->get_label( 'Filter Color' ), 'description' => $this->get_label( 'Select background filter color' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-filter-gradient\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::select( array( 'id' => 'otw-row-element-background_filter_gradient', 'label' => $this->get_label( 'Filter Gradient' ), 'description' => $this->get_label( 'Select Filter Gradient Type. Then select the two colors you want to transition between.' ), 'options' => array( '' => $this->get_label( 'none (default)' ), 'top_bottom' => $this->get_label( 'Top to Bottom' ), 'left_right' => $this->get_label( 'Left to Right' ), 'diagonal_bottom_right' => $this->get_label( 'Diagonal to bottom right' ) ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-filter-gradient-color1\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::color_picker( array( 'id' => 'otw-row-element-background_filter_gradient_color1', 'label' => $this->get_label( 'Color Stop 1' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-filter-gradient-color2\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::color_picker( array( 'id' => 'otw-row-element-background_filter_gradient_color2', 'label' => $this->get_label( 'Color Stop 2' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr id=\"otw-element-background-filter-opacity\">";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::text_input( array( 'id' => 'otw-row-element-background_filter_opacity', 'label' => $this->get_label( 'Filter Opacity' ), 'description' => $this->get_label( 'Could be a value between 0 and 1. For example 0.61. Leave empty for no opacity.' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
			$content .= "<tr>";
			$content .= "\t<td>";
			$content .= "\n".OTW_Form::text_input( array( 'id' => 'otw-row-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this row separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
			$content .= "\n</td>";
			$content .= "</tr>";
		$content .= "</table>";
		
		$content .= "\n<div class=\"otw-clear\" id=\"otw-row-editor-buttons-bottom\">
					<div class=\"alignleft\">
						<input type=\"button\" accesskey=\"C\" value=\"".$this->get_label('Cancel')."\" name=\"cancel\" class=\"button\" id=\"otw-row-editor-btn-cancel-bottom\">
					</div>
					<div class=\"alignright\">
						<input type=\"button\" accesskey=\"I\" value=\"".$this->get_label('Save')."\" name=\"insert\" class=\"button-primary\" id=\"otw-row-editor-btn-save-bottom\">
					</div>
					<div class=\"otw-clear\"></div>
				</div>";
		$content .= "\n</div>";
		echo $content;
		die;
	}
	
	public function build_add_column_dialog(){
		
		$content = "";
		
		$content .= "\n<div class=\"otw_grid_manager_column_dlg_wrapper\">";
		$content .= "\n<h3>".$this->get_label('Choose column type')."</h3>";
		$content .= "\n<div class=\"otw_grid_manager_column_dlg\">";
		$content .= "\n<div class=\"otw_grid_manager_column_dlg_container\">";
		$content .= "\n<div class=\"otw_grid_manager_column_dlg_row\">";
		$content .= "\n<div class=\"otw-twentyfour otw-columns\"><div class=\"otw-column-content otw-column-1_1\">1/1</div></div>";
		$content .= "\n</div>";
		$content .= "\n<div class=\"otw_grid_manager_column_dlg_row\">";
		$content .= "\n<div class=\"otw-twelve otw-columns\"><div class=\"otw-column-content otw-column-1_2\">1/2</div></div>";
		$content .= "\n</div>";
		$content .= "\n<div class=\"otw_grid_manager_column_dlg_row\">
				<div class=\"otw-eight otw-columns\"><div class=\"otw-column-content otw-column-1_3\">1/3</div></div>
				<div class=\"otw-sixteen otw-columns\"><div class=\"otw-column-content otw-column-2_3\">2/3</div></div>
			</div>";
		$content .= "\n<div class=\"otw_grid_manager_column_dlg_row\">
				<div class=\"otw-six otw-columns\"><div class=\"otw-column-content otw-column-1_4\">1/4</div></div>
				<div class=\"otw-eighteen otw-columns\"><div class=\"otw-column-content otw-column-3_4\">3/4</div></div>
			</div>";
		$content .= "\n<div class=\"otw_grid_manager_column_dlg_row\">
				<div class=\"otw-four otw-columns\"><div class=\"otw-column-content otw-column-1_6\">1/6</div></div>
				<div class=\"otw-twenty otw-columns\"><div class=\"otw-column-content otw-column-5_6\">5/6</div></div>
			</div>";
		$content .= "\n</div><div>";
		$content .= "\n<h3 class=\"adv_settings\" id=\"adv_settings\">".$this->get_label('Advanced settings')."</h3>";
		$content .= "\n<div class=\"adv_settings_container\" id=\"adv_settings_mobile_container\">";
		$content .= "\n<h4 class=\"otw_mobile\"><span>".$this->get_label( 'Mobile Grid' )."</span><img src=\"".$this->component_url."img/gm-advanced-down-arrow.png\" alt=\"\" /></h4>";
		$content .= "\n<div id=\"adv_settings_mobile_content\">";
		$content .= "\n<p>".$this->get_label( 'The grid has two modes of adapting for small displays like phones.<br />The first requires no work at all - the grid will linearize on a small device so your columns stack vertically (all in one column). If you don’t know what you are doing leave it as is and it should be all fine.<br />The other mode can take your existing grid elements and attach them to a six column phone grid. This means you can have 1, 2 or 3 columns on mobile devices. Note that you need to have all columns in a given row set up correctly in order to make it work.<br />Here is an example of two columns in a row.<br />This is correct: 1/2 +1/2<br />This is incorrect: 2/3 + 1/2 because it is more than a full row<br />This is incorrect: 1/3 + 1/3 because it doesn’t make a full row.' )."</p>";
		$content .= "\n".OTW_Form::select( array( 'id' => 'otw_mobile_column_size', 'options' => $this->mobile_grid_columns ) );
		$content .= "\n</div>";
		$content .= "\n</div>";
		
		$content .= "\n<div class=\"alignleft otw_grid_manager_column_dlg_row_buttons\">
					<input type=\"button\" accesskey=\"S\" value=\"".$this->get_label('Save')."\" name=\"save_settings\" class=\"button\" id=\"otw-shortcode-btn-save\">
					<input type=\"button\" accesskey=\"C\" value=\"".$this->get_label('Cancel')."\" name=\"cancel_settings\" class=\"button\" id=\"otw-shortcode-btn-cancel\">
				</div>";

		$content .= "\n</div>";
		echo $content;
		die;
	}
	
	/** 
	 *  Show meta content
	 */
	public function filter_show_meta_content( $post_content ){
		
		global $post;
		
		$meta_code = '';
		
		$meta_content = get_post_meta( $post->ID, $this->meta_name, TRUE );
		
		if( strlen( $meta_content ) ){
			
			$meta_code = $this->decode_grid_content( $this->meta_name."_".$post->ID, $meta_content );
		}
		
		return $post_content.' '.$this->otw_shortcode_remove_wpautop( $meta_code );
	}
	
	/**
	 * decode grid content
	 */
	public function decode_grid_content( $grid_id, $grid_code ){
		
		$grid_content = '';
		
		if( strlen( $grid_code ) ){
			
			$rows = json_decode( $grid_code );
			
			if( $rSize = count( $rows ) ){
				
				$grid_content .= " <div class=\"otw_gm_content\" id=\"".$grid_id."\">";
				foreach( $rows as $row_num => $row ){
					
					if( $cSize = count( $row->columns )){
					
						$row_css_class = 'otw-row';
						
						$row_css = '';
						
						$row_style = '';
					
						if( isset( $row->settings ) && isset( $row->settings->css_class ) && strlen( trim( $row->settings->css_class ) ) ){
							$row_css_class .= ' '.$row->settings->css_class;
						}
						
						$row_attributes = '';
						
						if( isset( $row->settings->stretch ) && isset( $row->settings->stretch ) && strlen( trim( $row->settings->stretch ) ) ){
							$row_attributes .= ' data-otwrowstretch="'.esc_attr( $row->settings->stretch ).'"';
						}
						if( isset( $row->settings->padding_top ) && isset( $row->settings->padding_top ) && strlen( trim( $row->settings->padding_top ) ) ){
							$row_attributes .= ' data-otwrowpaddingtop="'.esc_attr( $row->settings->padding_top ).'"';
						}
						if( isset( $row->settings->padding_bottom ) && isset( $row->settings->padding_bottom ) && strlen( trim( $row->settings->padding_bottom ) ) ){
							$row_attributes .= ' data-otwrowpaddingbottom="'.esc_attr( $row->settings->padding_bottom ).'"';
						}
						if( isset( $row->settings->height ) && isset( $row->settings->height ) && strlen( trim( $row->settings->height ) ) ){
							$row_attributes .= ' data-otwrowheight="'.esc_attr( $row->settings->height ).'"';
						}
						if( isset( $row->settings->background ) && ( $row->settings->background == 'image' ) ){
						
							if( isset( $row->settings->background_image ) && strlen( trim( $row->settings->background_image ) ) ){
								$row_attributes .= ' data-otwrowbgimage="'.esc_attr( $row->settings->background_image ).'"';
							}
							if( isset( $row->settings->background_image_size ) && strlen( trim( $row->settings->background_image_size ) ) ){
								$row_attributes .= ' data-otwrowbgimagesize="'.esc_attr( $row->settings->background_image_size ).'"';
							}
						}
						if( isset( $row->settings->background ) && ( $row->settings->background == 'video' ) ){
							
							if( isset( $row->settings->background_video ) && strlen( trim( $row->settings->background_video ) ) ){
							
								if( preg_match( "/youtube.com/", $row->settings->background_video ) ){
									
									if( preg_match( '%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $row->settings->background_video, $id_matches ) ){
										$row_attributes .= ' data-otwrowbgytvideo="'.esc_attr( $id_matches[1] ).'"';
									}
									
								}elseif( preg_match( "/vimeo.com/", $row->settings->background_video ) ){
									
									$row_attributes .= ' data-otwrowbgvmvideo="'.esc_attr( $row->settings->background_video ).'"';
									
								}else{
									
									$row_attributes .= ' data-otwrowbgvideo="'.esc_attr( $row->settings->background_video ).'"';
								}
							}
							
							if( isset( $row->settings->background_video_sound ) && strlen( trim( $row->settings->background_video_sound ) ) ){
								$row_attributes .= ' data-otwrowbgvideosound="'.esc_attr( $row->settings->background_video_sound ).'"';
							}
							if( isset( $row->settings->background_video_quality ) && strlen( trim( $row->settings->background_video_quality ) ) ){
								$row_attributes .= ' data-otwrowbgvideoquality="'.esc_attr( $row->settings->background_video_quality ).'"';
							}
							if( isset( $row->settings->background_video_repeat ) && strlen( trim( $row->settings->background_video_repeat ) ) ){
								$row_attributes .= ' data-otwrowbgvideorepeat="'.esc_attr( $row->settings->background_video_repeat ).'"';
							}
						}
						if( isset( $row->settings->background ) && ( $row->settings->background == 'color' ) ){
						
							if( isset( $row->settings->background_color ) && strlen( trim( $row->settings->background_color ) ) ){
								$row_attributes .= ' data-otwrowbgcolor="'.esc_attr( $row->settings->background_color ).'"';
							}else{
								$row_attributes .= ' data-otwrowbgcolor=""';
							}
							
							$row_style .= 'background: '.$row->settings->background_color.';';
						}
						if( isset( $row->settings->background ) && ( $row->settings->background == 'featured_image' ) ){
						
							if( isset( $this->post_item_id ) && $this->post_item_id ){
								
								global $otw_post_items_data;
								
								if( isset( $otw_post_items_data[ $this->post_item_id ] ) ){
								
									$f_image = get_the_post_thumbnail_url( $this->post_item_id );
									
									if( strlen( trim( $f_image ) ) ){
										
										$row_attributes .= ' data-otwrowbgimage="'.esc_attr( $f_image ).'"';
									}
								}
							}
						}
						if( isset( $row->settings->background ) && ( $row->settings->background == 'animation_color' ) ){
						
							if( isset( $row->settings->background_color_animation_color100 ) && strlen( trim( $row->settings->background_color_animation_color100 ) ) ){
								$row_attributes .= ' data-otwrowbgcolor="'.esc_attr( $row->settings->background_color_animation_color100 ).'"';
							}else{
								$row_attributes .= ' data-otwrowbgcolor=""';
							}
							
							if( isset( $row->settings->background_color_animation_color100 ) && strlen( trim( $row->settings->background_color_animation_color100 ) ) ){
								$row_style .= 'background: '.$row->settings->background_color_animation_color100.';';
							}
							
							if( isset( $row->settings->background_color_animation_duration ) ){
								$row_style .= 'animation: '.$row->settings->background_color_animation_duration.'s rowbgrf'.$row_num.' '.$row->settings->background_color_animation_count.';';
							}
							
							$row_css .= "@keyframes rowbgrf".$row_num." {
									0% {background: ".$row->settings->background_color_animation_color0.";}
									50% {background: ".$row->settings->background_color_animation_color50.";}
									100% {background: ".$row->settings->background_color_animation_color100.";}
								}";
						}
						
						if( isset( $row->settings->background_filter ) && ( in_array( $row->settings->background_filter, array( 'color', 'gradient' ) ) ) ){
						
							$row_attributes .= ' data-otwrowbgfilter="'.esc_attr( $row->settings->background_filter ).'"';
							
							if( isset( $row->settings->background_filter_color ) && strlen( trim( $row->settings->background_filter_color ) ) ){
								$row_attributes .= ' data-otwrowbgfiltercolor="'.esc_attr( $row->settings->background_filter_color ).'"';
							}
							
							if( isset( $row->settings->background_filter_opacity ) && strlen( trim( $row->settings->background_filter_opacity ) ) ){
								$row_attributes .= ' data-otwrowbgfilteropacity="'.esc_attr( $row->settings->background_filter_opacity ).'"';
							}
							
							if( isset( $row->settings->background_filter_gradient ) && strlen( trim( $row->settings->background_filter_gradient ) ) ){
								$row_attributes .= ' data-otwrowbgfiltergradient="'.esc_attr( $row->settings->background_filter_gradient ).'"';
								
								if( isset( $row->settings->background_filter_gradient_color1 ) && strlen( trim( $row->settings->background_filter_gradient_color1 ) ) ){
									$row_attributes .= ' data-otwrowbgfiltergradientcolor1="'.esc_attr( $row->settings->background_filter_gradient_color1 ).'"';
								}
								if( isset( $row->settings->background_filter_gradient_color2 ) && strlen( trim( $row->settings->background_filter_gradient_color2 ) ) ){
									$row_attributes .= ' data-otwrowbgfiltergradientcolor2="'.esc_attr( $row->settings->background_filter_gradient_color2 ).'"';
								}
							}
						}
						
						if( isset( $row->settings->parallax ) && strlen( trim( $row->settings->parallax ) ) ){
							
							wp_enqueue_script( 'otw_skrollr', $this->component_url.'js/skrollr.min.js', array(), $this->js_version, true );
							
							$row_attributes .= ' data-otwrowparallax="'.esc_attr( $row->settings->parallax ).'"';
						}
						
						if( strlen( trim( $row_style ) ) ){
							$row_style = ' style="'.esc_attr( $row_style ).'"';
						}
						
						$grid_content .= "<div id=\"".$grid_id."_row_".$row_num."\" class=\"".$row_css_class."\"".$row_attributes."".$row_style.">";
						
						
						$cCount = 1;
						foreach( $row->columns as $column_num => $column ){
							
							$is_last = '';
							
							if( $cCount == $cSize ){
								$is_last = ' last="1"';
							}
							
							$column_class = $this->number_names[ ( ( $this->grid_size / $column->from_rows ) * $column->rows ) ];
							$grid_content .= '[otw_shortcode_post_template_grid_column rows="'.esc_attr( $column->rows ).'" from_rows="'.esc_attr( $column->from_rows ).'" mobile_rows="'.esc_attr( $column->mobile_rows ).'" mobile_from_rows="'.esc_attr( $column->mobile_from_rows ).'"'.$is_last.']';
							if( count( $column->shortcodes ) ){
								
								foreach( $column->shortcodes as $shortcode_num => $shortcode ){
									$grid_shortcode_code = $shortcode->shortcode_code;
									if( preg_match( "/^\[otw_shortcode_post_[^\s^\]*]+/", $grid_shortcode_code, $shortcode_matches ) ){
										$grid_shortcode_code = preg_replace( "/^(\[otw_shortcode_post_[^\s^\]*]+)/", '$1 post_item_id='.$this->post_item_id.' ssid="'.( $grid_id.'_'.$row_num.'_'.$column_num.'_'.$shortcode_num ).'"', $grid_shortcode_code );
									}
									$grid_content .= $grid_shortcode_code;
								}
							}
							$grid_content .= '[/otw_shortcode_post_template_grid_column]';
							
							
							$cCount++;
						}
						
						if( isset( $row->settings->background ) && ( $row->settings->background == 'video' ) ){
							
							if( isset( $row->settings->background_video ) && strlen( trim( $row->settings->background_video ) ) ){
							
								if( preg_match( "/youtube.com/", $row->settings->background_video ) ){
									
									wp_enqueue_script( 'otw_youtube_iframe_api_js', 'https://www.youtube.com/iframe_api', array(), $this->js_version, true );
									
									$attributes = '';
									
									if( isset( $row->settings->background_video_size ) && ( $row->settings->background_video_size == 'original'  ) ){
										
										$video_code = wp_oembed_get( $row->settings->background_video );
										
										if( preg_match( "/\s+width=\"(\d+)\%?\"/", $video_code, $video_attmatch ) ){
											$attributes .= ' data-orwidth="'.esc_attr( $video_attmatch[1] ).'"';
										}
										if( preg_match( "/\s+height=\"(\d+)\%?\"/", $video_code, $video_attmatch ) ){
											$attributes .= ' data-orheight="'.esc_attr( $video_attmatch[1] ).'"';
										}
									}
									
									$grid_content .= "<div class=\"otw_row_bg_video\"".$attributes."><div></div>";
									$grid_content .= "</div>";
								}
								elseif( preg_match( "/vimeo.com/", $row->settings->background_video ) ){
									
									wp_enqueue_script( 'otw_froogaloop_iframe_api_js', 'https://f.vimeocdn.com/js/froogaloop2.min.js', array(), $this->js_version, true );
									
									$params_string = '?api=1&autoplay=1&player_id=otw_vm_'.self::$vimeo_player_id;
									
									if( !isset( $row->settings->background_video_repeat ) || !strlen( trim( $row->settings->background_video_repeat ) ) || ( $row->settings->background_video_repeat == 'no' ) ){
										$params_string .= '&loop=0';
									}else{
										$params_string .= '&loop=1';
									}
									
									if( isset( $row->settings->background_video_quality ) && strlen( trim( $row->settings->background_video_quality ) ) ){
									
										switch( $row->settings->background_video_quality ){
											
											case 'small':
													$params_string .= '&quality=360p';
												break;
											case 'medium':
											case 'large':
													$params_string .= '&quality=540p';
												break;
											case 'hd720':
													$params_string .= '&quality=720p';
												break;
											case 'hd1080':
													$params_string .= '&quality=1080p';
												break;
											case 'highres':
													$params_string .= '&quality=2K';
												break;
											case 'auto':
												break;
										}
									
									}
									if( !isset( $row->settings->background_video_sound ) || !strlen( trim( $row->settings->background_video_sound ) ) || ( $row->settings->background_video_sound != '1' ) ){
										$params_string .= '&background=1';
									}
									
									$grid_content .= "<div class=\"otw_row_bg_video\">";
									$video_code = wp_oembed_get( $row->settings->background_video );
									
									if( preg_match( "/src\=\"([^\"]*)\"/", $video_code, $url_matches ) ){
										
										$video_code = str_replace( $url_matches[0], 'src="'.$url_matches[1].str_replace( '&', '&amp;', $params_string ).'" id="otw_vm_'.esc_attr( self::$vimeo_player_id ).'"', $video_code );
										self::$vimeo_player_id++;
									}
									
									if( isset( $row->settings->background_video_size ) && ( $row->settings->background_video_size == 'original'  ) ){
									}else{
										$video_code = preg_replace( "/\s+width=\"(\d+)\%?\"/", " width=\"100%\"", $video_code );
										$video_code = preg_replace( "/\s+height=\"(\d+)\%?\"/", " height=\"100%\"", $video_code );
									}
									$grid_content .= $video_code;
									$grid_content .= "</div>";
								}else{
									$grid_content .= "<div class=\"otw_row_bg_video\">";
									$video_code = wp_oembed_get( $row->settings->background_video );
									$video_code = preg_replace( "/\s+width=\"(\d+)\%?\"/", " width=\"100%\"", $video_code );
									$video_code = preg_replace( "/\s+height=\"(\d+)\%?\"/", " height=\"100%\"", $video_code );
									$grid_content .= $video_code;
									$grid_content .= "</div>";
								}
								
							}
							
						}
						$grid_content .= "</div>";
					}
					
					if( strlen( trim( $row_css ) ) ){
						$grid_content .= '<style type="text/css">'.$row_css.'</style>';
					}
				}
				$grid_content .= "</div>";
			}
		}
		return $grid_content;
	}
	
	/**
	 * Row Shortcode
	 */
	public function otw_shortcode_grid_row( $attributes, $content ){
		
		$html = '<div class="otw-row">'.$this->otw_shortcode_remove_wpautop( $content ).'</div>';
		
		return $html;
	}
	/**
	 * Column Shortcode
	 */
	public function otw_shortcode_grid_column( $attributes, $content ){
	
		$column_class = $this->number_names[ ( ( $this->grid_size / $attributes['from_rows'] ) * $attributes['rows'] ) ];
		
		if( isset( $attributes['mobile_rows'] ) && isset( $attributes['mobile_from_rows'] ) && ( $attributes['mobile_rows'] > 0 ) && ( $attributes['mobile_from_rows'] > 0 ) ){
			$column_class .= ' mobile-'.$this->number_names[ ( ( $this->mobile_grid_size / $attributes['mobile_from_rows'] ) * $attributes['mobile_rows'] ) ];
		}
		
		$is_last = '';
		if( isset( $attributes['last'] ) && ( $attributes['last'] == 1 ) ){
			$is_last = ' end';
		}
		$html  = "";
		$html .= "<div class=\"otw-".$column_class." otw-columns".$is_last."\">";
		$html .= $this->otw_shortcode_remove_wpautop( $content );
		$html .= "</div>";
	
		return $html;
	}
	
	/**
	 * Load saved template
	 */
	public function otw_load_template(){
		
		
		if( otw_post( 'grid_manager', false ) && ( otw_post( 'grid_manager', '' ) == $this->meta_name ) &&  ( otw_post( 'template_key', false ) !== false )  ){
			
			$saved_templates = get_option( $this->meta_name.'_templates', '' );
			
			if( strlen( trim( $saved_templates ) ) ){
				$saved_templates_array = unserialize( $saved_templates );
				
				if( !$saved_templates_array ){
					$saved_templates_array = array();
				}
				
			}else{
				$saved_templates_array = array();
			}
			
			if( array_key_exists( otw_post( 'template_key', '' ), $saved_templates_array ) ){
				
				echo stripslashes( $saved_templates_array[ otw_post( 'template_key', '' ) ]['code'] );
				die;
			}
		}
		echo '-1';
		die;
	}
	
	/**
	 * Deleted saved template
	 */
	public function otw_delete_template(){
		
		if( otw_post( 'grid_manager', false ) && ( otw_post( 'grid_manager', '' ) == $this->meta_name ) &&  ( otw_post( 'template_key', false ) !== false ) ){
			
			$saved_templates = get_option( $this->meta_name.'_templates', '' );
			
			if( strlen( trim( $saved_templates ) ) ){
				$saved_templates_array = unserialize( $saved_templates );
				
				if( !$saved_templates_array ){
					$saved_templates_array = array();
				}
				
			}else{
				$saved_templates_array = array();
			}
			
			if( array_key_exists( otw_post( 'template_key', '' ), $saved_templates_array ) ){
				unset( $saved_templates_array[ otw_post( 'template_key', '' ) ] );
			}
			
			update_option(  $this->meta_name.'_templates',  serialize( $saved_templates_array ) );
			
			$js_template = array();
			foreach( $saved_templates_array as $template_key => $template ){
				$js_template[] = array( $template_key, $template['name'] );
			}
			echo json_encode( $js_template );
			die;
		}
		echo '-1';
		die;
	}
	
	/**
	 * Save current page as template
	 */
	public function otw_save_template(){
	
		$saved_templates = get_option( $this->meta_name.'_templates', '' );
		
		if( otw_post( 'grid_manager', false ) && ( otw_post( 'grid_manager', '' ) == $this->meta_name ) ){
			
			if( strlen( trim( $saved_templates ) ) ){
				$saved_templates_array = unserialize( $saved_templates );
				if( !$saved_templates_array ){
					$saved_templates_array = array();
				}
			}else{
				$saved_templates_array = array();
			}
			
			if( otw_post( 'template_name', false ) &&  strlen( trim( otw_post( 'template_name', '' ) ) ) ){
				
				$saved_templates_array[] = array( 'name' => otw_post( 'template_name', '' ), 'code' => otw_post( 'template_code', '' ) );
				
				update_option(  $this->meta_name.'_templates',  serialize( $saved_templates_array ) );
			}
			
			$js_template = array();
			foreach( $saved_templates_array as $template_key => $template ){
				$js_template[] = array( $template_key, $template['name'] );
			}
			echo json_encode( $js_template );
			die;
		}
		echo '-1';
		die;
	}
	
	/**
	 * Check if the content sidebars component will change the content of current requested object
	 * 
	 * @return boolean
	 */
	public function is_valid_for_object(){
		
		if( isset( $GLOBALS['wp_query'] ) ){
			
			global $post;
			
			if( isset( $post->ID ) && $post->ID ){
				
				$meta_content = get_post_meta( $post->ID, $this->meta_name, TRUE );
				
				if( strlen( $meta_content ) ){
				
					$rows = json_decode( $meta_content );
					
					if( $rSize = count( $rows ) ){
						
						foreach( $rows as $row ){
							return true;
						}
					}
				}
			}
		}
		
		return false;
	}
	
	public function include_admin_scripts(){
		
		wp_enqueue_script('otw_post_template_grid_manager_admin', $this->component_url.'js/otw_post_template_grid_manager_admin.js?' , array( 'jquery' ), $this->js_version );
		wp_enqueue_style( 'otw_post_template_grid_manager_admin', $this->component_url.'css/otw-grid-admin.css', array( ), $this->css_version );
		wp_enqueue_style( 'otw_grid_manager', $this->component_url.'css/otw-grid.css', array( ), $this->css_version );
	}
}
?>