
<div class="meta-box-sortables otw_pctp_ct_settings">
	<?php $otw_pctp_content_sidebars_object->content_sidebars_standalone( 'pct', $otw_pctp_custom_template_values['cs'] );?>
	<div class="postbox">
		<h3 class="hndle sitem_header"><span><?php esc_html_e( 'OTW Post Template Options.', 'otw_pctp' )?></span></h3>
		<div class="inside">

			<table class="form-table">
				<tr class="otw_pct_template_related_settings">
					<th scope="row">
						<label for="otw_pct_item_title"><?php esc_html_e('Post Title', 'otw_pctp');?></label>
					</th>
					<td>
						<select name="otw_pct_item_title_font_size" id="otw_pct_item_title_font_size">
							<?php foreach( $controls_options['font_sizes'] as $element_key => $element_data ){?>
								<?php 
									$selected = '';
									
									if( $otw_pctp_custom_template_values['options']['otw_pct_item_title_font_size'] == $element_data['value'] ){
										$selected = ' selected="selected"';
									}
								
								?>
								<option value="<?php echo esc_attr( $element_data['value'] )?>"<?php echo $selected;?> ><?php echo otw_esc_text( $element_data['text'] )?></option>
							<?php }?>
						</select>
						<select name="otw_pct_item_title_font_style" id="otw_pct_item_title_font_style">
							<?php foreach( $controls_options['font_styles'] as $element_key => $element_data ){?>
								<?php 
									$selected = '';
									
									if( $otw_pctp_custom_template_values['options']['otw_pct_item_title_font_style'] == $element_data['value'] ){
										$selected = ' selected="selected"';
									}
								
								?>
								<option value="<?php echo esc_attr( $element_data['value'] )?>"<?php echo $selected;?> ><?php echo otw_esc_text( $element_data['text'] )?></option>
							<?php }?>
						</select>
						<select name="otw_pct_item_title_font_name"  class="js-fonts" data-placeholder="<?php esc_html_e( 'Font Family', 'otw-pctp' )?>" data-value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_item_title_font_name'] );?>" data-allow-clear="true"></select>
						<div class="otw-pct-color-picker">
							<div class="js-color-picker-icon js-color-picker">
								<div class="js-color-container" style="background-color: <?php echo $otw_pctp_custom_template_values['options']['otw_pct_item_title_color'];?>;"></div>
							</div>
							<input type="text" name="otw_pct_item_title_color" class="js-color-picker-value" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_item_title_color'] );?>"/>
						</div>
						<p class="description"><?php esc_html_e('Adjust the style of the post title.', 'otw_pctp');?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row">
						<label for="otw_pct_item_title_alignment"><?php esc_html_e('Post Title Text Alignment', 'otw_pctp');?></label>
					</th>
					<td>
						<select name="otw_pct_item_title_alignment" id="otw_pct_item_title_alignment">
							<?php foreach( $controls_options['alignments'] as $element_key => $element_data ){?>
								<?php 
									$selected = '';
									
									if( $otw_pctp_custom_template_values['options']['otw_pct_item_title_alignment'] == $element_data['value'] ){
										$selected = ' selected="selected"';
									}
								
								?>
								<option value="<?php echo esc_attr( $element_data['value'] )?>"<?php echo $selected;?> ><?php echo otw_esc_text( $element_data['text'] )?></option>
							<?php }?>
						</select>
						<p class="description"><?php esc_html_e('Choose the title alignment.', 'otw_pctp');?></p>
					</td>
				</tr>
				<?php if( count( $meta_elements  ) ){?>
				<tr class="otw_pct_template_related_settings">
					<th scope="row">
						<label for="meta_order"><?php esc_html_e('Meta Elements and Order', 'otw_pctp');?></label>
					</th>
					<td>
						<div class="active_elements">
							<h3><?php esc_html_e('Active Elements', 'otw_pctp');?></h3>
							<input type="hidden" name="otw_pct_meta_items" class="js-meta-items" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_meta_items'] );?>"/>
							<ul class="b-meta-box js-meta-active" style="height: <?php echo esc_attr( $meta_elements_height )?>px;">
							</ul>
						</div>
						<div class="inactive_elements">
							<h3><?php esc_html_e('Inactive Elements', 'otw_pctp');?></h3>
							<ul class="b-meta-box js-meta-inactive" style="height: <?php echo $meta_elements_height?>px;">
							<?php foreach( $meta_elements as $meta_element_key => $meta_element_name ){?>
								<li data-item="meta" data-value="<?php echo esc_attr( $meta_element_key )?>" class="b-meta-items js-meta--item"><?php echo otw_esc_text( $meta_element_name )?></li>
							<?php }?>
							</ul>
						</div>
						<p class="description"><?php esc_html_e('Drag & drop the items that you\'d like to show in the Active Elements area on the left. Arrange them however you want to see them.', 'otw_pctp');?></p>
					</td>
				</tr>
				<tr valign="top" class="otw_pct_template_related_settings">
					<th scope="row">
						<label for="otw_pct_meta_type_align"><?php esc_html_e('Meta Type:', 'otw_pctp');?></label>
					</th>
					<td>
						<select name="otw_pct_meta_type_align" id="otw_pct_meta_type_align">
						<?php 
						foreach( $selectMetaData as $optionData ): 
							$selected = '';
							if( $optionData['value'] === $otw_pctp_custom_template_values['options']['otw_pct_meta_type_align'] ) {
								$selected = 'selected="selected"';
							}
							echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
							
						endforeach;
						?>
						</select>
						<p class="description"><?php esc_html_e('Choose between horizontal and vertical meta style.', 'otw_pctp');?></p>
					</td>
				</tr>
				<tr valign="top" class="otw_pct_template_related_settings">
					<th scope="row">
						<label for="otw_pct_meta_icons"><?php esc_html_e('Meta Icons:', 'otw_pctp');?></label>
					</th>
					<td>
						<?php
							$yes = ''; $no = ''; 
							($otw_pctp_custom_template_values['options']['otw_pct_meta_icons'] == 'icons')? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
						?>
						<input type="radio" name="otw_pct_meta_icons" id="meta_icons-no" value="labels" <?php echo $no;?>/> 
						<label for="meta_icons-no"><?php esc_html_e('No (default)', 'otw_pctp');?></label>
						<input type="radio" name="otw_pct_meta_icons" id="meta_icons-yes" value="icons" <?php echo $yes;?>/> 
						<label for="meta_icons-yes"><?php esc_html_e('Yes', 'otw_pctp');?></label>
						<p class="description"><?php esc_html_e('Choose yes if you want to have icons instead of labels in your meta.', 'otw_pctp');?>
					</td>
				</tr>
				<?php }?>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_prev_next_nav"><?php esc_html_e('Enable Previous / Next Post Navigation', 'otw_pctp'); ?></label></th>
					<td>
						<select id="otw_pct_prev_next_nav" name="otw_pct_prev_next_nav">
						<?php foreach( $otw_pct_prev_next_nav_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pctp_custom_template_values['options']['otw_pct_prev_next_nav'] ) && ( $otw_pctp_custom_template_values['options']['otw_pct_prev_next_nav'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Enable Previous / Next Post Navigation for single post page.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_related_posts"><?php esc_html_e('Enable Related Posts', 'otw_pctp'); ?></label></th>
					<td>
						<select id="otw_pct_related_posts" name="otw_pct_related_posts">
						<?php foreach( $otw_pct_related_posts_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pctp_custom_template_values['options']['otw_pct_related_posts'] ) && ( $otw_pctp_custom_template_values['options']['otw_pct_related_posts'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Enable Related Posts.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_related_posts_criteria"><?php esc_html_e('Related Post Criteria', 'otw_pctp'); ?></label></th>
					<td>
						<select id="otw_pct_related_posts_criteria" name="otw_pct_related_posts_criteria">
						<?php foreach( $otw_pct_related_posts_criteria_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pctp_custom_template_values['options']['otw_pct_related_posts_criteria'] ) && ( $otw_pctp_custom_template_values['options']['otw_pct_related_posts_criteria'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Select the Related Post Criteria', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_related_posts_number"><?php esc_html_e('Related Posts Count per Slide', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_related_posts_number" id="otw_pct_related_posts_number" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_related_posts_number'] )?>" />
						<p class="description"><?php esc_html_e( 'This is how many related posts will be visible per slide of the carousel. Default is 4.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_social_title_text"><?php esc_html_e('Social Icons Title Text', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_social_title_text" id="otw_pct_social_title_text" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_social_title_text'] )?>" />
						<p class="description"><?php esc_html_e( 'Enter custom Social Icons Title Text. If empty "Hey, like this? Why not share it with a buddy?" will be used. If you enter a "space" no title will be displayed.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_moreinfo_title_text"><?php esc_html_e('Post Tabs Title Text', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_moreinfo_title_text" id="otw_pct_moreinfo_title_text" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_moreinfo_title_text'] )?>" />
						<p class="description"><?php esc_html_e( 'Enter custom Post Tabs Title Text. If empty "More Info" will be used. If you enter a "space" no title will be displayed.', 'otw_pctp' )?></p>
					</td>
				</tr>

				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_related_title_text"><?php esc_html_e('Related posts Title Text', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_related_title_text" id="otw_pct_related_title_text" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_related_title_text'] )?>" />
						<p class="description"><?php esc_html_e( 'Enter custom Related posts Title Text. If empty "Related posts" will be used. If you enter a "space" no title will be displayed.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_reviews_title_text"><?php esc_html_e('Post Reviews Title Text', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_reviews_title_text" id="otw_pct_reviews_title_text" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_reviews_title_text'] )?>" />
						<p class="description"><?php esc_html_e( 'Enter custom Post Reviews Title Text. If empty "Post Reviews" will be used. If you enter a "space" no title will be displayed.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_post_fields_title_text"><?php esc_html_e('Post Fields Title Text', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_post_fields_title_text" id="otw_pct_post_fields_title_text" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_post_fields_title_text'] )?>" />
						<p class="description"><?php esc_html_e( 'Enter custom Post Fields Title Text. If empty "Post Fields" will be used. If you enter a "space" no title will be displayed.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_post_fields_delimiters"><?php esc_html_e('Post Fields Show delimiters', 'otw_pctp'); ?></label></th>
					<td>
						<select id="otw_pct_post_fields_delimiters" name="otw_pct_post_fields_delimiters">
						<?php foreach( $otw_pct_post_fields_delimiters_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pctp_custom_template_values['options']['otw_pct_post_fields_delimiters'] ) && ( $otw_pctp_custom_template_values['options']['otw_pct_post_fields_delimiters'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Enable Post Fields delimiters.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr valign="top" class="otw_pct_template_related_settings">
					<th scope="row">
						<label for="show-social-icons"><?php esc_html_e('Show Social Icons', 'otw_pctp');?></label>
					</th>
					<td>
						<?php
							$yes = ''; $no = ''; 
							($otw_pctp_custom_template_values['options']['otw_pct_show_social_icons'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
						?>
						<select id="show-social-icons" name="otw_pct_show_social_icons">
							<?php 
								foreach( $otw_pct_social_icons_options as $optionData ){
									$selected = '';
									if( $optionData['value'] === $otw_pctp_custom_template_values['options']['otw_pct_show_social_icons'] ) {
										$selected = 'selected="selected"';
									}
									echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
								}
							?>
						</select>
						<p class="description">
							<?php
								esc_html_e("Social Icons will make your posts easy to share in social networks. Note that to use 
									\"Share buttons small\" and \"Share buttons large\" you need to have CURL installed on your server.
									", 'otw_pctp');
							?>
						</p>
					</td>
				</tr>
				<tr id="otw-show-social-icons-type" class="otw_pct_template_related_settings">
					<th scope="row">
						<label for="otw_pct_show_social_icons_type"><?php esc_html_e('Select Social Icons', 'otw_pctp');?></label>
					</th>
					<td>
						<input type="checkbox" id="otw_pct_show_social_icons_type" name="otw_pct_show_social_icons_facebook" value="1" <?php echo ( $otw_pctp_custom_template_values['options']['otw_pct_show_social_icons_facebook'] )?' checked="checked"':''?> /><label for="otw_pct_show_social_icons_type"><?php esc_html_e('Facebook', 'otw_pctp');?></label>
						<input type="checkbox" id="otw_pct_show_social_icons_twitter" name="otw_pct_show_social_icons_twitter" value="1" <?php echo ( $otw_pctp_custom_template_values['options']['otw_pct_show_social_icons_twitter'] )?' checked="checked"':''?>/><label for="otw_pct_show_social_icons_twitter"><?php esc_html_e('Twitter', 'otw_pctp');?></label>
						<input type="checkbox" id="otw_pct_show_social_icons_googleplus" name="otw_pct_show_social_icons_googleplus" value="1" <?php echo ( $otw_pctp_custom_template_values['options']['otw_pct_show_social_icons_googleplus'] )?' checked="checked"':''?>/><label for="otw_pct_show_social_icons_googleplus"><?php esc_html_e('Google+', 'otw_pctp');?></label>
						<input type="checkbox" id="otw_pct_show_social_icons_linkedin" name="otw_pct_show_social_icons_linkedin" value="1" <?php echo ( $otw_pctp_custom_template_values['options']['otw_pct_show_social_icons_linkedin'] )?' checked="checked"':''?>/><label for="otw_pct_show_social_icons_linkedin"><?php esc_html_e('LinkedIn', 'otw_pctp');?></label>
						<input type="checkbox" id="otw_pct_show_social_icons_pinterest" name="otw_pct_show_social_icons_pinterest" value="1" <?php echo ( $otw_pctp_custom_template_values['options']['otw_pct_show_social_icons_pinterest'] )?' checked="checked"':''?>/><label for="otw_pct_show_social_icons_pinterest"><?php esc_html_e('Pinterest', 'otw_pctp');?></label>
						<p class="description"><?php esc_html_e( 'Select the social icons that will be displayed.', 'otw_pctp');?></p>
					</td>
				</tr>
				<tr id="otw-show-social-icons-custom" class="otw_pct_template_related_settings">
					<th scope="row">
						<label for="otw_pct_show_social_icons_custom"><?php esc_html_e('Custom Social Icons', 'otw_pctp');?></label>
					</th>
					<td>
						<textarea id="otw_pct_show_social_icons_custom" name="otw_pct_show_social_icons_custom" rows="6" cols="80"><?php echo ( $otw_pctp_custom_template_values['options']['otw_pct_show_social_icons_custom'] )?></textarea>
						<p class="description"><?php esc_html_e( 'Insert your Custom Social Icons. HTML and Shortcodes are allowed.', 'otw_pctp');?></p>
					</td>
				</tr>
				<tr valign="top" id="otw-show-social-icons-alignment" class="otw_pct_template_related_settings">
					<th scope="row">
						<label for="show-social_icons_alignment"><?php esc_html_e('Post Social Icons Alignment', 'otw_pctp');?></label>
					</th>
					<td>
						<select id="show-social-icons-alignment" name="otw_pct_social_icons_alignment">
							<?php foreach( $controls_options['alignments'] as $element_key => $element_data ){?>
								<?php 
									$selected = '';
									
									if( $otw_pctp_custom_template_values['options']['otw_pct_social_icons_alignment'] == $element_data['value'] ){
										$selected = ' selected="selected"';
									}
								
								?>
								<option value="<?php echo esc_attr( $element_data['value'] )?>"<?php echo $selected;?> ><?php echo otw_esc_text( $element_data['text'] )?></option>
							<?php }?>
						</select>
						<p class="description">
							<?php
								esc_html_e( 'Choose the Post Social Icons alignment.', 'otw_pctp');
							?>
						</p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_item_media_width"><?php esc_html_e('Media Width', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_item_media_width" id="otw_pct_item_media_width" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_item_media_width'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 650px.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_item_media_height"><?php esc_html_e('Media Height', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_item_media_height" id="otw_pct_item_media_height" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_item_media_height'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 580px.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_item_media_format"><?php esc_html_e('Media Format', 'otw_pctp'); ?></label></th>
					<td>
						<select id="otw_pct_item_media_format" name="otw_pct_item_media_format">
						<?php foreach( $otw_pct_item_media_format_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pctp_custom_template_values['options']['otw_pct_item_media_format'] ) && ( $otw_pctp_custom_template_values['options']['otw_pct_item_media_format'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Cropping images formats.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr valign="top" class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_item_media_alt_attr"><?php esc_html_e('Add alt tag', 'otw_pctp');?></label></th>
					<td>
						<?php ( empty($otw_pctp_custom_template_values['options']['otw_pct_item_media_alt_attr']) )? $otw_pct_item_media_alt_attr = 'no' : $otw_pct_item_media_alt_attr = $otw_pctp_custom_template_values['options']['otw_pct_item_media_alt_attr']; ?>
						<select name="otw_pct_item_media_alt_attr" id="otw_pct_item_media_alt_attr">
							<option value="no" <?php echo ( $otw_pct_item_media_alt_attr == 'no' )?'selected="selected"':'';?> ><?php esc_html_e( 'No (default)', 'otw_pctp');?></option>
							<option value="media_settings" <?php echo ( $otw_pct_item_media_alt_attr == 'media_settings' )?'selected="selected"':'';?> ><?php esc_html_e( 'Use what is set in the Media Library', 'otw_pctp');?></option>
						</select>
						<p class="description"><?php esc_html_e('The alt tag helps position your images in search engines.', 'otw_pctp');?></p>
					</td>
				</tr>
				<tr valign="top" class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_item_media_title_attr"><?php esc_html_e('Add title tag', 'otw_pctp');?></label></th>
					<td>
						<?php ( empty($otw_pctp_custom_template_values['options']['otw_pct_item_media_title_attr']) )? $otw_pct_item_media_title_attr = 'no' : $otw_pct_item_media_title_attr = $otw_pctp_custom_template_values['options']['otw_pct_item_media_title_attr']; ?>
						<select name="otw_pct_item_media_title_attr" id="otw_pct_item_media_title_attr">
							<option value="no" <?php echo ( $otw_pct_item_media_title_attr == 'no' )?'selected="selected"':'';?> ><?php esc_html_e( 'No (default)', 'otw_pctp');?></option>
							<option value="media_settings" <?php echo ( $otw_pct_item_media_title_attr == 'media_settings' )?'selected="selected"':'';?> ><?php esc_html_e( 'Use what is set in the Media Library', 'otw_pctp');?></option>
						</select>
						<p class="description"><?php esc_html_e('The title tag helps position your images in search engines and is displayed on hover of the image.', 'otw_pctp');?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_related_media_width"><?php esc_html_e('Related Posts Media Width', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_related_media_width" id="otw_pct_related_media_width" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_related_media_width'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 220px.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_related_media_height"><?php esc_html_e('Related Posts Media Height', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_related_media_height" id="otw_pct_related_media_height" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_related_media_height'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 150px.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_related_media_format"><?php esc_html_e('Related Posts Media Format', 'otw_pctp'); ?></label></th>
					<td>
						<select id="otw_pct_related_media_format" name="otw_pct_related_media_format">
						<?php foreach( $otw_pct_item_media_format_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pctp_custom_template_values['options']['otw_pct_related_media_format'] ) && ( $otw_pctp_custom_template_values['options']['otw_pct_related_media_format'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Cropping images formats.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_media_lightbox"><?php esc_html_e('Enable Media Lightbox', 'otw_pctp'); ?></label></th>
					<td>
						<select id="otw_pct_media_lightbox" name="otw_pct_media_lightbox">
						<?php foreach( $otw_pct_media_lightbox_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pctp_custom_template_values['options']['otw_pct_media_lightbox'] ) && ( $otw_pctp_custom_template_values['options']['otw_pct_media_lightbox'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Enables a lightbox on click on the media.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_item_media_lightbox_width"><?php esc_html_e('Media Lightbox Width', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_item_media_lightbox_width" id="otw_pct_item_media_lightbox_width" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_item_media_lightbox_width'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 1024px.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_item_media_lightbox_height"><?php esc_html_e('Media Lightbox Height', 'otw_pctp'); ?></label></th>
					<td>
						<input type="text" name="otw_pct_item_media_lightbox_height" id="otw_pct_item_media_lightbox_height" value="<?php echo esc_attr( $otw_pctp_custom_template_values['options']['otw_pct_item_media_lightbox_height'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 640px.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_item_media_lightbox_format"><?php esc_html_e('Media Lightbox Format', 'otw_pctp'); ?></label></th>
					<td>
						<select id="otw_pct_item_media_lightbox_format" name="otw_pct_item_media_lightbox_format">
						<?php foreach( $otw_pct_item_media_format_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pctp_custom_template_values['options']['otw_pct_item_media_lightbox_format'] ) && ( $otw_pctp_custom_template_values['options']['otw_pct_item_media_lightbox_format'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Cropping images formats.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_item_theme_post_header"><?php esc_html_e('Theme Post Header Code', 'otw_pctp'); ?></label></th>
					<td>
						<textarea name="otw_pct_item_theme_post_header" id="otw_pct_item_theme_post_header"><?php echo otw_esc_text( $otw_pctp_custom_template_values['options']['otw_pct_item_theme_post_header'] )?></textarea>
						<p class="description"><?php esc_html_e( 'HTML that is not included in your theme header', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr class="otw_pct_template_related_settings">
					<th scope="row"><label for="otw_pct_item_theme_pre_footer"><?php esc_html_e('Theme Pre Footer Code', 'otw_pctp'); ?></label></th>
					<td>
						<textarea name="otw_pct_item_theme_pre_footer" id="otw_pct_item_theme_pre_footer"><?php echo otw_esc_text( $otw_pctp_custom_template_values['options']['otw_pct_item_theme_pre_footer'] )?></textarea>
						<p class="description"><?php esc_html_e( 'HTML that is not included in your theme footer', 'otw_pctp' )?></p>
					</td>
				</tr>
			</table>
		</div>
	</div>
</div>