<?php global $wp_registered_sidebars ?>
<input type="hidden" name="otw_pctp_meta_options" value="1" />
<table class="form-table otw_pctp_options_table">
	<tbody>
		<tr>
			<th><label for="otw_pct_options_type"><?php esc_html_e( 'Select default or custom template:', 'otw_pctp' );?></label></th>
			<td>
				<select id="otw_pct_options_type" name="otw_pct_options_type">
					<option value="default"<?php echo ( $otw_pct_options_meta_data['otw_pct_options_type']=='default' )?' selected="selected"':''?> ><?php esc_html_e( 'Default', 'otw_pctp' );?></option>
					<option value="custom"<?php echo ( $otw_pct_options_meta_data['otw_pct_options_type']=='custom' )?' selected="selected"':''?> ><?php esc_html_e( 'Custom', 'otw_pctp' );?></option>
				</select>
    				<p class="description"><?php esc_html_e( 'Default means that you want to apply the default options set in Post Custom Templates -> Options -> Post Template Selection. Custom means the options that will apply for this post is what you set bellow.', 'otw_pctp' );?></p>
			</td>
		</tr>
	</tbody>
</table>
<table class="form-table" id="otw_pct_custom_options_table">
	<tr>
		<th scope="row"><label for="otw_pct_template"><?php esc_html_e('Template', 'otw_pctp'); ?></label></th>
		<td>
			<select id="otw_pct_template" name="otw_pct_template">
			<?php foreach( $otw_pct_templates as $template_key => $template_name ){?>
				<?php
					$selected = '';
					if( isset( $otw_pct_options_meta_data['options']['otw_pct_template'] ) && ( $otw_pct_options_meta_data['options']['otw_pct_template'] == $template_key ) ){
						$selected = ' selected="selected"';
					}
				?>
				<?php if( $template_key == '-' ){ ?>
					<option disabled="disabled">------------------------------------------</option>
				<?php }else{ ?>
					<option value="<?php echo esc_attr( $template_key )?>"<?php echo $selected?>><?php echo esc_html( $template_name )?></option>
				<?php } ?>
			<?php }?>
			</select>
			<p class="description"><?php esc_html_e( 'This is the template for your single post.', 'otw_pctp' )?></p>
		</td>
	</tr>
	<tr id="otw_pct_template_sidebar" class="otw_pct_template_related_settings">
		<th scope="row"><label for="otw_pct_sidebar"><?php esc_html_e('Single post sidebar', 'otw_pctp'); ?></label></th>
		<td>
			<select id="otw_pct_sidebar" name="otw_pct_sidebar">
			<?php foreach( $wp_registered_sidebars as $sb_key => $sb_data ){?>
				<?php
					$selected = '';
					if( isset( $otw_pct_options_meta_data['options']['otw_pct_sidebar'] ) && ( $otw_pct_options_meta_data['options']['otw_pct_sidebar'] == $sb_key ) ){
						$selected = ' selected="selected"';
					}
				?>
				<option value="<?php echo esc_attr( $sb_key )?>"<?php echo $selected?>><?php echo esc_html( $sb_data['name'] )?></option>
			<?php }?>
			</select>
			<p class="description"><?php esc_html_e( 'This is the sidebar for your single post template.', 'otw_pctp' )?></p>
		</td>
	</tr>
</table>