<?php
global $otw_pctp_plugin_id;

$db_values = array();

$db_values['otw_pct_promotions'] = get_option( $otw_pctp_plugin_id.'_dnms' );

if( empty( $db_values['otw_pct_promotions'] ) ){
	$db_values['otw_pct_promotions'] = 'on';
}

$message = '';
$massages = array();
$messages[1] = esc_html__( 'Options saved', 'otw_pctp' );

if( otw_get('message',false) && isset( $messages[ otw_get('message','') ] ) ){
	$message .= $messages[ otw_get('message','') ];
}
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo otw_esc_text( $message ); ?></p></div>
<?php endif; ?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php esc_html_e('Plugin Options', 'otw_pctp') ?>
	</h2>
	<form name="otw-pctp-list-style" method="post" action="" class="validate otw-pctp-options-form">
		<h3><?php esc_html_e('Post Template Selection', 'otw_pctp'); ?></h3>
		<div class="otw_pctp_sp_settings" id="otw_pctp_settings">
			<table class="form-table">
				<tr>
					<th scope="row"><label for="otw_pct_template"><?php esc_html_e('Single post template', 'otw_pctp'); ?></label></th>
					<td>
						<select id="otw_pct_template" name="otw_pct_template">
						<?php foreach( $otw_pct_templates as $template_key => $template_name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pct_plugin_options['otw_pct_template'] ) && ( $otw_pct_plugin_options['otw_pct_template'] == $template_key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<?php if( $template_key == '-' ){ ?>
								<option disabled="disabled">------------------------------------------</option>
							<?php }else{ ?>
								<option value="<?php echo esc_attr( $template_key )?>"<?php echo $selected?>><?php echo otw_esc_text( $template_name )?></option>
							<?php } ?>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'This is the template that applies to all of your single posts.', 'otw_pctp' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label><?php esc_html_e('All posts from category template', 'otw_pctp'); ?></label>
					</th>
					<td>
						<p class="description"><?php esc_html_e( 'Select a category then apply a template to all posts that are in this category. If a post is in more than one category then the category template on top of this list will be applied.', 'otw_pctp' )?></p>
						<table class="otw-pct-template-table"  cellspacing="0">
							<tr valign="top">
								<td class="otw_ct_table_cell1">
									<label for="otw_new_ct_category"><?php esc_html_e('Select Category', 'otw_pctp'); ?></label><br />
									<select name="otw_new_ct_category" id="otw_new_ct_category" class="js-category" data-allow-clear="true" data-value=""></select>
								</td>
								<td class="otw_ct_table_cell2">
									<label for="otw_new_ct_template"><?php esc_html_e('Select Template', 'otw_pctp'); ?></label><br />
									<select id="otw_new_ct_template" name="otw_new_ct_template">
									<?php foreach( $otw_pct_templates as $template_key => $template_name ){?>
										<?php if( $template_key == '-' ){ ?>
											<option disabled="disabled">------------------------------------------</option>
										<?php }else{ ?>
											<option value="<?php echo esc_attr( $template_key )?>"><?php echo otw_esc_text( $template_name )?></option>
										<?php } ?>
									<?php }?>
									</select>
								</td>
								<td class="otw_ct_table_cell3">
									<div id="otw_new_ct_sidebar_holder">
										<label for="otw_new_ct_sidebar"><?php esc_html_e('Select Sidebar', 'otw_pctp'); ?></label><br />
										<select id="otw_new_ct_sidebar" name="otw_new_ct_sidebar">
											<?php foreach( $wp_registered_sidebars as $sb_key => $sb_data ){?>
												<option value="<?php echo esc_attr( $sb_key )?>"<?php echo $selected?>><?php echo esc_html( $sb_data['name'] )?></option>
											<?php }?>
										</select>
									</div>
								</td>
								<td valign="bottom" class="otw_ct_table_cell4">
									<br />
									<a href="javascript:;" class="add-new-h2" id="otw_add_category_template"><?php esc_html_e( 'Add', 'otw_pctp' );?></a>
									<input type="hidden" id="otw_pct_category_template" name="otw_pct_category_template" value="<?php echo otw_stripslashes( otw_htmlentities( $otw_pct_plugin_options['otw_pct_category_template'] ) )?>" />
								</td>
							</tr>
						</table>
						<div id="otw_pct_ct_table"></div>
					</td>
				</tr>
			</table>
		</div>
		<div>
			<p class="submit">
				<input type="submit" value="<?php esc_html_e( 'Save', 'otw_pctp') ?>" name="submit" class="button button-primary button-hero"/>
			</p>
		</div>
		<h3><?php esc_html_e('Promotion Messages', 'otw_pctp'); ?></h3>
		<div class="otw_pctp_sp_settings">
			<div class="form-field">
				<label for="otw_pct_promotions"><?php esc_html_e('Show OTW Promotion Messages in my WordPress admin', 'otw_pctp'); ?></label>
				<select id="otw_pct_promotions" name="otw_pct_promotions">
					<option value="on" <?php echo ( isset( $db_values['otw_pct_promotions'] ) && ( $db_values['otw_pct_promotions'] == 'on' ) )? 'selected="selected"':''?>>on(default)</option>
					<option value="off"<?php echo ( isset( $db_values['otw_pct_promotions'] ) && ( $db_values['otw_pct_promotions'] == 'off' ) )? 'selected="selected"':''?>>off</option>
				</select>
			</div>
		</div>
		<h3><?php esc_html_e('Custom CSS', 'otw_pctp'); ?></h3>
		<p class="description"><?php esc_html_e('Adjust your own CSS for all of your templates. Please use with caution.', 'otw_pctp'); ?></p>
		<div>
			<textarea name="otw_pctp_custom_css" cols="100" rows="35" class="otw-pctp-custom-css"><?php echo otw_esc_text( $customCss );?></textarea>
			<p class="submit">
				<input type="hidden" name="otw_pctp_save_settings" value="1" />
				<input type="hidden" name="otw_pctp_action" value="manage_otw_pctp_options" />
				<?php wp_original_referer_field(true, 'previous'); wp_nonce_field('otw-pctp-options'); ?>
				<input type="submit" value="<?php esc_html_e( 'Save', 'otw_pctp') ?>" name="submit" class="button button-primary button-hero"/>
			</p>
		</div>
	</form>
</div>
