<?php 
  //Get Categories for Current Post
  $catArray = wp_get_post_categories( $post->ID );
  if( is_array( $catArray ) ) : 
?>
<!-- Post Categories -->
<div class="otw_post_content-blog-category">
<?php switch( $this->view_data['settings']['otw_pct_meta_icons'] ){
	case 'icons':
			if( !empty( $this->view_data['settings']['otw_pct_meta_category_icon'] ) ){?>
				<span class="head"><i class="fa <?php echo $this->view_data['settings']['otw_pct_meta_category_icon'] ?>"></i></span>
			<?php }else{ ?>
				<span class="head"><i class="fa fa-folder-open-o"></i></span>
			<?php }?>
		<?php break;
	case 'none':
		break;
	case 'labels':
	default:
			if( !empty( $this->view_data['settings']['otw_pct_meta_category_text'] ) ){?>
				<span class="head"><?php echo otw_esc_text( $this->view_data['settings']['otw_pct_meta_category_text'] )?></span>
			<?php }else{ ?>
				<span class="head"><?php esc_html_e('Category:', 'otw_pctp');?></span>
			<?php }?>
		<?php break;?>
<?php } ?>
  <?php 
    foreach( $catArray as $index => $cat ):
      $category = get_category($cat);
      $catUrl = get_category_link( $category->term_id );
  ?>
  <a href="<?php echo esc_attr( esc_url($catUrl) );?>" rel="category" title="<?php esc_html_e('View all posts in ', 'otw_pctp'); echo $category->name;?>">
    <?php echo $category->name;?>
  </a>
  <?php if( $index < count( $catArray ) - 1 ) { echo ', '; }?>
  <?php
    endforeach;
  ?>
</div>
<!-- END Post Categories -->
<?php endif; ?>