<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function() {
    const days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    const todayIndex = new Date().getDay(); // 0 for Sunday, 1 for Monday, etc.
    const currentDayName = days[todayIndex];

    const listItems = document.querySelectorAll('.opening-hours ul li');

    listItems.forEach(item => {
        const dayText = item.firstChild.textContent.trim(); // Get the day text from the li
        if (dayText.startsWith(currentDayName)) {
            item.classList.add('current-day');
        }
    });
});
</script>
<!-- end Simple Custom CSS and JS -->
